/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jmc.joverflow.util;

import java.lang.ref.WeakReference;
import java.util.logging.Logger;

public class StringInterner {
    private static final Logger LOGGER = Logger.getLogger("org.openjdk.jmc.joverflow.util");
    private static final WeakReference<String>[] table;
    private static int size;
    private static final int threshold;
    private static volatile int numCalls;
    private static volatile int numResets;

    static {
        int length = (int)(Runtime.getRuntime().totalMemory() / 100L / 100L);
        length = Integer.highestOneBit(length);
        table = new WeakReference[length];
        threshold = length * 3 / 4;
    }

    public static String internString(String s) {
        WeakReference<String> entry;
        if (s == null) {
            return null;
        }
        ++numCalls;
        int index = s.hashCode();
        index = StringInterner.hash(index);
        index &= table.length - 1;
        int gapIdx = -1;
        while ((entry = table[index]) != null) {
            String cachedValue = (String)entry.get();
            if (cachedValue == null) {
                if (gapIdx == -1) {
                    gapIdx = index;
                }
                index = index + 1 & table.length - 1;
                continue;
            }
            if (cachedValue.equals(s)) {
                return cachedValue;
            }
            index = index + 1 & table.length - 1;
        }
        if (size > threshold && gapIdx == -1) {
            int i = 0;
            while (i < table.length) {
                StringInterner.table[i] = null;
                ++i;
            }
            size = 0;
            ++numResets;
        }
        if (gapIdx != -1) {
            index = gapIdx;
        } else {
            ++size;
        }
        StringInterner.table[index] = new WeakReference<String>(s);
        return s;
    }

    public static Object internStringInObjectRef(Object obj) {
        if (!(obj instanceof String)) {
            return obj;
        }
        return StringInterner.internString((String)obj);
    }

    public static String[] internStringArrayContents(String[] arr) {
        if (arr == null) {
            return null;
        }
        int i = 0;
        while (i < arr.length) {
            String result = StringInterner.internString(arr[i]);
            if (result != null) {
                arr[i] = result;
            }
            ++i;
        }
        return arr;
    }

    public static Object[] internStringsInObjectArray(Object[] arr) {
        if (arr == null) {
            return null;
        }
        int i = 0;
        while (i < arr.length) {
            Object result = StringInterner.internStringInObjectRef(arr[i]);
            if (result != null) {
                arr[i] = result;
            }
            ++i;
        }
        return arr;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void printInternStats() {
        int numNullEntries = 0;
        WeakReference<String>[] weakReferenceArray = table;
        synchronized (table) {
            WeakReference<String>[] weakReferenceArray2 = table;
            int n = table.length;
            int n2 = 0;
            while (n2 < n) {
                WeakReference<String> tableEntry = weakReferenceArray2[n2];
                if (tableEntry == null) {
                    ++numNullEntries;
                }
                ++n2;
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            LOGGER.info("Table size: " + table.length + ", null entries: " + numNullEntries);
            LOGGER.info("Num calls (may be off due to overflowing): " + numCalls);
            LOGGER.info("Num resets: " + numResets);
            return;
        }
    }

    private static int hash(int h) {
        int key = h ^ 0x3D ^ h >>> 16;
        key += key << 3;
        key ^= key >>> 4;
        key *= 668265261;
        key ^= key >>> 15;
        return key;
    }
}

