/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jmc.ui.celleditors;

import org.eclipse.jface.fieldassist.ControlDecoration;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.openjdk.jmc.ui.celleditors.ClearableTextCellEditor;
import org.openjdk.jmc.ui.misc.ControlDecorationToolkit;

public class ParsingCellEditor
extends ClearableTextCellEditor {
    private final ControlDecoration errorDecorator;
    private Object value;

    public ParsingCellEditor(Composite parent) {
        super(parent);
        this.errorDecorator = ControlDecorationToolkit.createErrorDecorator((Control)this.text);
    }

    @Override
    public void activate() {
        super.activate();
        this.errorDecorator.hide();
    }

    protected void editOccured(ModifyEvent e) {
        try {
            String str = this.text.getText();
            this.value = this.allowClear() && "".equals(str.trim()) ? null : this.parse(str);
            this.setValueValid(true);
            this.errorDecorator.hide();
        }
        catch (Exception ex) {
            this.errorDecorator.setDescriptionText(ex.getLocalizedMessage());
            this.errorDecorator.show();
            this.setValueValid(false);
        }
    }

    protected Object parse(String str) throws Exception {
        return str;
    }

    protected String format(Object value) {
        return value == null ? "" : value.toString();
    }

    protected void doSetValue(Object value) {
        this.value = value;
        super.doSetValue((Object)this.format(value));
    }

    protected Object doGetValue() {
        return this.value;
    }
}

