/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jmc.ui.celleditors;

import org.eclipse.jface.fieldassist.ControlDecoration;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Text;
import org.openjdk.jmc.common.unit.ITypedQuantity;
import org.openjdk.jmc.common.unit.IUnit;
import org.openjdk.jmc.common.unit.LinearUnit;
import org.openjdk.jmc.common.util.TypeHandling;
import org.openjdk.jmc.ui.celleditors.ParsingCellEditor;
import org.openjdk.jmc.ui.misc.QuantityKindProposal;

public class UnitCellEditor
extends ParsingCellEditor {
    private final ControlDecoration decoration;
    private final QuantityKindProposal proposal;
    private IUnit unit;
    private Class<?> valueType;
    private boolean isPrimitive;

    public UnitCellEditor(Composite parent) {
        super(parent);
        this.proposal = QuantityKindProposal.install((Text)this.text);
        this.decoration = this.proposal.getDecorator();
    }

    public void setUnit(IUnit unit, String valueType) {
        this.unit = unit;
        this.proposal.setUnit(unit);
        try {
            this.valueType = TypeHandling.toNonPrimitiveClass((Class)TypeHandling.getClassWithName((String)valueType));
        }
        catch (Exception exception) {
            this.valueType = Object.class;
        }
        this.isPrimitive = TypeHandling.isPrimitive((String)valueType);
        String infoText = super.getInfoText();
        if (infoText != null) {
            this.decoration.setDescriptionText(String.valueOf(infoText) + "\n" + this.decoration.getDescriptionText());
        }
    }

    protected QuantityKindProposal getProposal() {
        return this.proposal;
    }

    @Override
    public boolean allowClear() {
        return !this.isPrimitive;
    }

    @Override
    public String getInfoText() {
        return null;
    }

    @Override
    protected Object parse(String str) throws Exception {
        ITypedQuantity q = this.unit instanceof LinearUnit ? ((LinearUnit)this.unit).customParseInteractive(str) : this.unit.getContentType().parseInteractive(str);
        if (this.valueType.equals(Byte.class)) {
            return (byte)q.longValueIn(this.unit, 127L);
        }
        if (this.valueType.equals(Short.class)) {
            return (short)q.longValueIn(this.unit, 32767L);
        }
        if (this.valueType.equals(Integer.class)) {
            return (int)q.longValueIn(this.unit, Integer.MAX_VALUE);
        }
        if (this.valueType.equals(Long.class)) {
            return q.longValueIn(this.unit);
        }
        if (this.valueType.equals(Float.class)) {
            return Float.valueOf((float)q.doubleValueIn(this.unit));
        }
        if (this.valueType.equals(Double.class)) {
            return q.doubleValueIn(this.unit);
        }
        throw new Exception("Type not supported");
    }

    public static boolean canEdit(String valueType) {
        try {
            if (valueType != null) {
                Class c = TypeHandling.toNonPrimitiveClass((Class)TypeHandling.getClassWithName((String)valueType));
                return c.equals(Byte.class) || c.equals(Short.class) || c.equals(Integer.class) || c.equals(Long.class) || c.equals(Float.class) || c.equals(Double.class);
            }
            return false;
        }
        catch (Exception exception) {
            return false;
        }
    }

    @Override
    protected String format(Object value) {
        if (value == null) {
            return "";
        }
        if (this.unit instanceof LinearUnit) {
            return ((LinearUnit)this.unit).quantity((Number)value).interactiveFormat(true);
        }
        return this.unit.quantity((Number)value).interactiveFormat();
    }

    protected void focusLost() {
        if (!this.proposal.isPopupOpen()) {
            super.focusLost();
        }
    }

    protected boolean dependsOnExternalFocusListener() {
        return false;
    }
}

