/*
 * Decompiled with CFR 0.152.
 */
package graphql.execution.incremental;

import graphql.ExecutionResult;
import graphql.ExecutionResultImpl;
import graphql.Internal;
import graphql.com.google.common.collect.ImmutableCollection;
import graphql.com.google.common.collect.ImmutableList;
import graphql.com.google.common.collect.ImmutableListMultimap;
import graphql.com.google.common.collect.ImmutableSet;
import graphql.execution.ExecutionContext;
import graphql.execution.ExecutionStrategyParameters;
import graphql.execution.FieldValueInfo;
import graphql.execution.MergedField;
import graphql.execution.MergedSelectionSet;
import graphql.execution.incremental.DeferredCallContext;
import graphql.execution.incremental.DeferredExecution;
import graphql.execution.incremental.DeferredFragmentCall;
import graphql.execution.incremental.IncrementalCall;
import graphql.execution.instrumentation.Instrumentation;
import graphql.incremental.IncrementalPayload;
import graphql.util.FpKit;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.function.BiFunction;
import java.util.function.Supplier;
import java.util.stream.Collectors;

@Internal
public interface DeferredExecutionSupport {
    public static final DeferredExecutionSupport NOOP = new NoOp();

    public boolean isDeferredField(MergedField var1);

    public int deferredFieldsCount();

    public List<String> getNonDeferredFieldNames(List<String> var1);

    public Set<IncrementalCall<? extends IncrementalPayload>> createCalls(ExecutionStrategyParameters var1);

    public static class NoOp
    implements DeferredExecutionSupport {
        @Override
        public boolean isDeferredField(MergedField mergedField) {
            return false;
        }

        @Override
        public int deferredFieldsCount() {
            return 0;
        }

        @Override
        public List<String> getNonDeferredFieldNames(List<String> allFieldNames) {
            return allFieldNames;
        }

        @Override
        public Set<IncrementalCall<? extends IncrementalPayload>> createCalls(ExecutionStrategyParameters executionStrategyParameters) {
            return Collections.emptySet();
        }
    }

    public static class DeferredExecutionSupportImpl
    implements DeferredExecutionSupport {
        private final ImmutableListMultimap<DeferredExecution, MergedField> deferredExecutionToFields;
        private final ImmutableSet<MergedField> deferredFields;
        private final ImmutableList<String> nonDeferredFieldNames;
        private final ExecutionStrategyParameters parameters;
        private final ExecutionContext executionContext;
        private final BiFunction<ExecutionContext, ExecutionStrategyParameters, CompletableFuture<FieldValueInfo>> resolveFieldWithInfoFn;
        private final Map<String, Supplier<CompletableFuture<DeferredFragmentCall.FieldWithExecutionResult>>> dfCache = new HashMap<String, Supplier<CompletableFuture<DeferredFragmentCall.FieldWithExecutionResult>>>();

        public DeferredExecutionSupportImpl(MergedSelectionSet mergedSelectionSet, ExecutionStrategyParameters parameters, ExecutionContext executionContext, BiFunction<ExecutionContext, ExecutionStrategyParameters, CompletableFuture<FieldValueInfo>> resolveFieldWithInfoFn) {
            this.executionContext = executionContext;
            this.resolveFieldWithInfoFn = resolveFieldWithInfoFn;
            ImmutableListMultimap.Builder deferredExecutionToFieldsBuilder = ImmutableListMultimap.builder();
            ImmutableSet.Builder deferredFieldsBuilder = ImmutableSet.builder();
            ImmutableList.Builder nonDeferredFieldNamesBuilder = ImmutableList.builder();
            mergedSelectionSet.getSubFields().values().forEach(mergedField -> {
                mergedField.getDeferredExecutions().forEach(de -> {
                    deferredExecutionToFieldsBuilder.put(de, mergedField);
                    deferredFieldsBuilder.add(mergedField);
                });
                if (mergedField.getDeferredExecutions().isEmpty()) {
                    nonDeferredFieldNamesBuilder.add(mergedField.getSingleField().getResultKey());
                }
            });
            this.deferredExecutionToFields = deferredExecutionToFieldsBuilder.build();
            this.deferredFields = deferredFieldsBuilder.build();
            this.parameters = parameters;
            this.nonDeferredFieldNames = nonDeferredFieldNamesBuilder.build();
        }

        @Override
        public boolean isDeferredField(MergedField mergedField) {
            return this.deferredFields.contains(mergedField);
        }

        @Override
        public int deferredFieldsCount() {
            return this.deferredFields.size();
        }

        @Override
        public List<String> getNonDeferredFieldNames(List<String> allFieldNames) {
            return this.nonDeferredFieldNames;
        }

        @Override
        public Set<IncrementalCall<? extends IncrementalPayload>> createCalls(ExecutionStrategyParameters executionStrategyParameters) {
            return this.deferredExecutionToFields.keySet().stream().map(deferredExecution -> this.createDeferredFragmentCall((DeferredExecution)deferredExecution, executionStrategyParameters)).collect(Collectors.toSet());
        }

        private DeferredFragmentCall createDeferredFragmentCall(DeferredExecution deferredExecution, ExecutionStrategyParameters executionStrategyParameters) {
            DeferredCallContext deferredCallContext = new DeferredCallContext();
            ImmutableCollection mergedFields = this.deferredExecutionToFields.get((Object)deferredExecution);
            List<Supplier<CompletableFuture<DeferredFragmentCall.FieldWithExecutionResult>>> calls = mergedFields.stream().map(currentField -> this.createResultSupplier((MergedField)currentField, deferredCallContext, executionStrategyParameters)).collect(Collectors.toList());
            return new DeferredFragmentCall(deferredExecution.getLabel(), this.parameters.getPath(), calls, deferredCallContext);
        }

        private Supplier<CompletableFuture<DeferredFragmentCall.FieldWithExecutionResult>> createResultSupplier(MergedField currentField, DeferredCallContext deferredCallContext, ExecutionStrategyParameters executionStrategyParameters) {
            LinkedHashMap<String, MergedField> fields = new LinkedHashMap<String, MergedField>();
            fields.put(currentField.getResultKey(), currentField);
            ExecutionStrategyParameters callParameters = this.parameters.transform(builder -> {
                MergedSelectionSet mergedSelectionSet = MergedSelectionSet.newMergedSelectionSet().subFields(fields).build();
                builder.deferredCallContext(deferredCallContext).field(currentField).fields(mergedSelectionSet).path(this.parameters.getPath().segment(currentField.getResultKey())).parent(null);
            });
            Instrumentation instrumentation = this.executionContext.getInstrumentation();
            instrumentation.beginDeferredField(this.executionContext.getInstrumentationState());
            return this.dfCache.computeIfAbsent(currentField.getResultKey(), key -> FpKit.interThreadMemoize(() -> {
                CompletableFuture<FieldValueInfo> fieldValueResult = this.resolveFieldWithInfoFn.apply(this.executionContext, callParameters);
                CompletionStage executionResultCF = fieldValueResult.thenCompose(fvi -> {
                    this.executionContext.getDataLoaderDispatcherStrategy().executeDeferredOnFieldValueInfo((FieldValueInfo)fvi, executionStrategyParameters);
                    return fvi.getFieldValueFuture().thenApply(fv -> ((ExecutionResultImpl.Builder)ExecutionResultImpl.newExecutionResult().data(fv)).build());
                });
                return ((CompletableFuture)executionResultCF).thenApply(executionResult -> new DeferredFragmentCall.FieldWithExecutionResult(currentField.getResultKey(), (ExecutionResult)executionResult));
            }));
        }
    }
}

