/*
 * Decompiled with CFR 0.152.
 */
package graphql.execution.incremental;

import graphql.ExecutionResult;
import graphql.GraphQLError;
import graphql.Internal;
import graphql.com.google.common.collect.ImmutableList;
import graphql.execution.Async;
import graphql.execution.NonNullableFieldWasNullError;
import graphql.execution.NonNullableFieldWasNullException;
import graphql.execution.ResultPath;
import graphql.execution.incremental.DeferredCallContext;
import graphql.execution.incremental.IncrementalCall;
import graphql.incremental.DeferPayload;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.function.Supplier;

@Internal
public class DeferredFragmentCall
implements IncrementalCall<DeferPayload> {
    private final String label;
    private final ResultPath path;
    private final List<Supplier<CompletableFuture<FieldWithExecutionResult>>> calls;
    private final DeferredCallContext deferredCallContext;

    public ResultPath getPath() {
        return this.path;
    }

    public DeferredFragmentCall(String label, ResultPath path, List<Supplier<CompletableFuture<FieldWithExecutionResult>>> calls, DeferredCallContext deferredCallContext) {
        this.label = label;
        this.path = path;
        this.calls = calls;
        this.deferredCallContext = deferredCallContext;
    }

    @Override
    public CompletableFuture<DeferPayload> invoke() {
        Async.CombinedBuilder futures = Async.ofExpectedSize(this.calls.size());
        this.calls.forEach(call -> {
            CompletableFuture cf = (CompletableFuture)call.get();
            futures.add(cf);
        });
        return ((CompletableFuture)futures.await().thenApply(this::transformToDeferredPayload)).handle(this::handleNonNullableFieldError);
    }

    private DeferPayload handleNonNullableFieldError(DeferPayload result, Throwable throwable) {
        if (throwable != null) {
            Throwable cause = throwable.getCause();
            if (cause instanceof NonNullableFieldWasNullException) {
                NonNullableFieldWasNullError error = new NonNullableFieldWasNullError((NonNullableFieldWasNullException)cause);
                return ((DeferPayload.Builder)((DeferPayload.Builder)((DeferPayload.Builder)DeferPayload.newDeferredItem().errors(Collections.singletonList(error))).label(this.label)).path(this.path)).build();
            }
            if (cause instanceof CompletionException) {
                throw (CompletionException)cause;
            }
            throw new CompletionException(cause);
        }
        return result;
    }

    private DeferPayload transformToDeferredPayload(List<FieldWithExecutionResult> fieldWithExecutionResults) {
        List<GraphQLError> errorsEncountered = this.deferredCallContext.getErrors();
        HashMap dataMap = new HashMap();
        ImmutableList.Builder errorsBuilder = ImmutableList.builder();
        fieldWithExecutionResults.forEach(entry -> {
            dataMap.put(entry.resultKey, entry.executionResult.getData());
            errorsBuilder.addAll(entry.executionResult.getErrors());
        });
        return ((DeferPayload.Builder)((DeferPayload.Builder)((DeferPayload.Builder)DeferPayload.newDeferredItem().errors((List)errorsEncountered)).path(this.path)).label(this.label)).data(dataMap).build();
    }

    public static class FieldWithExecutionResult {
        private final String resultKey;
        private final ExecutionResult executionResult;

        public FieldWithExecutionResult(String resultKey, ExecutionResult executionResult) {
            this.resultKey = resultKey;
            this.executionResult = executionResult;
        }

        public ExecutionResult getExecutionResult() {
            return this.executionResult;
        }
    }
}

