/*
 * Decompiled with CFR 0.152.
 */
package graphql.execution.reactive;

import graphql.Internal;
import graphql.execution.reactive.CompletionStageSubscriber;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.CompletionStage;
import java.util.function.Function;
import org.reactivestreams.Subscriber;

@Internal
public class CompletionStageOrderedSubscriber<U, D>
extends CompletionStageSubscriber<U, D>
implements Subscriber<U> {
    public CompletionStageOrderedSubscriber(Function<U, CompletionStage<D>> mapper, Subscriber<? super D> downstreamSubscriber) {
        super(mapper, downstreamSubscriber);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void whenNextFinished(CompletionStage<D> completionStage, D d, Throwable throwable) {
        try {
            if (throwable != null) {
                this.handleThrowableDuringMapping(throwable);
            } else {
                this.emptyInFlightQueueIfWeCan();
            }
        }
        finally {
            boolean empty = this.inFlightQIsEmpty();
            this.finallyAfterEachPromiseFinishes(empty);
        }
    }

    private void emptyInFlightQueueIfWeCan() {
        this.lock.runLocked(() -> {
            while (!this.inFlightDataQ.isEmpty()) {
                Object value;
                CompletionStage cs = (CompletionStage)this.inFlightDataQ.peek();
                if (cs == null) continue;
                CompletableFuture cf = cs.toCompletableFuture();
                if (!cf.isDone()) break;
                this.inFlightDataQ.poll();
                try {
                    value = cf.join();
                }
                catch (RuntimeException rte) {
                    this.handleThrowableDuringMapping(this.cfExceptionUnwrap(rte));
                    break;
                }
                this.downstreamSubscriber.onNext(value);
            }
        });
    }

    private Throwable cfExceptionUnwrap(Throwable throwable) {
        if (throwable instanceof CompletionException & throwable.getCause() != null) {
            return throwable.getCause();
        }
        return throwable;
    }
}

