/*
 * Decompiled with CFR 0.152.
 */
package graphql.schema;

import graphql.Assert;
import graphql.PublicApi;
import graphql.introspection.Introspection;
import graphql.schema.GraphQLDirective;
import graphql.schema.GraphQLEnumType;
import graphql.schema.GraphQLInputObjectType;
import graphql.schema.GraphQLInterfaceType;
import graphql.schema.GraphQLList;
import graphql.schema.GraphQLNamedSchemaElement;
import graphql.schema.GraphQLNamedType;
import graphql.schema.GraphQLNonNull;
import graphql.schema.GraphQLObjectType;
import graphql.schema.GraphQLScalarType;
import graphql.schema.GraphQLSchemaElement;
import graphql.schema.GraphQLType;
import graphql.schema.GraphQLUnionType;
import graphql.schema.GraphQLUnmodifiedType;
import graphql.schema.idl.DirectiveInfo;
import graphql.schema.idl.ScalarInfo;
import java.util.Stack;
import java.util.function.Predicate;

@PublicApi
public class GraphQLTypeUtil {
    public static String simplePrint(GraphQLType type) {
        Assert.assertNotNull(type, () -> "type can't be null");
        if (GraphQLTypeUtil.isNonNull(type)) {
            return GraphQLTypeUtil.simplePrint(GraphQLTypeUtil.unwrapOne(type)) + "!";
        }
        if (GraphQLTypeUtil.isList(type)) {
            return "[" + GraphQLTypeUtil.simplePrint(GraphQLTypeUtil.unwrapOne(type)) + "]";
        }
        return ((GraphQLNamedType)type).getName();
    }

    public static String simplePrint(GraphQLSchemaElement schemaElement) {
        if (schemaElement instanceof GraphQLType) {
            return GraphQLTypeUtil.simplePrint((GraphQLType)schemaElement);
        }
        if (schemaElement instanceof GraphQLNamedSchemaElement) {
            return ((GraphQLNamedSchemaElement)schemaElement).getName();
        }
        return (String)Assert.assertShouldNeverHappen("unexpected schema element: " + schemaElement, new Object[0]);
    }

    public static boolean isNonNull(GraphQLType type) {
        return type instanceof GraphQLNonNull;
    }

    public static boolean isNullable(GraphQLType type) {
        return !GraphQLTypeUtil.isNonNull(type);
    }

    public static boolean isList(GraphQLType type) {
        return type instanceof GraphQLList;
    }

    public static boolean isWrapped(GraphQLType type) {
        return GraphQLTypeUtil.isList(type) || GraphQLTypeUtil.isNonNull(type);
    }

    public static boolean isNotWrapped(GraphQLType type) {
        return !GraphQLTypeUtil.isWrapped(type);
    }

    public static boolean isScalar(GraphQLType type) {
        return type instanceof GraphQLScalarType;
    }

    public static boolean isEnum(GraphQLType type) {
        return type instanceof GraphQLEnumType;
    }

    public static boolean isLeaf(GraphQLType type) {
        GraphQLUnmodifiedType unmodifiedType = GraphQLTypeUtil.unwrapAll(type);
        return unmodifiedType instanceof GraphQLScalarType || unmodifiedType instanceof GraphQLEnumType;
    }

    public static boolean isInput(GraphQLType type) {
        GraphQLUnmodifiedType unmodifiedType = GraphQLTypeUtil.unwrapAll(type);
        return unmodifiedType instanceof GraphQLScalarType || unmodifiedType instanceof GraphQLEnumType || unmodifiedType instanceof GraphQLInputObjectType;
    }

    public static GraphQLType unwrapOne(GraphQLType type) {
        if (GraphQLTypeUtil.isNonNull(type)) {
            return ((GraphQLNonNull)type).getWrappedType();
        }
        if (GraphQLTypeUtil.isList(type)) {
            return ((GraphQLList)type).getWrappedType();
        }
        return type;
    }

    public static <T extends GraphQLType> T unwrapOneAs(GraphQLType type) {
        return (T)GraphQLTypeUtil.unwrapOne(type);
    }

    public static GraphQLUnmodifiedType unwrapAll(GraphQLType type) {
        return (GraphQLUnmodifiedType)GraphQLTypeUtil.unwrapAllAs(type);
    }

    public static <T extends GraphQLType> T unwrapAllAs(GraphQLType type) {
        return (T)GraphQLTypeUtil.unwrapAllImpl(type);
    }

    private static GraphQLType unwrapAllImpl(GraphQLType type) {
        while (!GraphQLTypeUtil.isNotWrapped(type)) {
            type = GraphQLTypeUtil.unwrapOne(type);
        }
        return type;
    }

    public static GraphQLType unwrapNonNull(GraphQLType type) {
        while (GraphQLTypeUtil.isNonNull(type)) {
            type = GraphQLTypeUtil.unwrapOne(type);
        }
        return type;
    }

    public static <T extends GraphQLType> T unwrapNonNullAs(GraphQLType type) {
        return (T)GraphQLTypeUtil.unwrapNonNull(type);
    }

    public static Stack<GraphQLType> unwrapType(GraphQLType type) {
        Assert.assertNotNull(type);
        Stack<GraphQLType> decoration = new Stack<GraphQLType>();
        while (true) {
            decoration.push(type);
            if (GraphQLTypeUtil.isNotWrapped(type)) break;
            type = GraphQLTypeUtil.unwrapOne(type);
        }
        return decoration;
    }

    public static boolean isInterfaceOrUnion(GraphQLType type) {
        return type instanceof GraphQLInterfaceType || type instanceof GraphQLUnionType;
    }

    public static boolean isObjectType(GraphQLType type) {
        return type instanceof GraphQLObjectType;
    }

    public static Predicate<GraphQLNamedSchemaElement> isSystemElement() {
        return schemaElement -> {
            if (schemaElement instanceof GraphQLScalarType) {
                return ScalarInfo.isGraphqlSpecifiedScalar((GraphQLScalarType)schemaElement);
            }
            if (schemaElement instanceof GraphQLDirective) {
                return DirectiveInfo.isGraphqlSpecifiedDirective((GraphQLDirective)schemaElement);
            }
            if (schemaElement instanceof GraphQLNamedType) {
                return Introspection.isIntrospectionTypes((GraphQLNamedType)schemaElement);
            }
            return false;
        };
    }
}

