/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.bidi;

import java.lang.reflect.Type;
import java.util.Collections;
import java.util.Map;
import java.util.TreeMap;
import org.openqa.selenium.internal.Require;
import org.openqa.selenium.json.JsonInput;

public class BiDiSessionStatus {
    private final boolean ready;
    private final String message;

    public BiDiSessionStatus(boolean ready, String message) {
        this.ready = Require.nonNull("Session's readiness", ready);
        this.message = Require.nonNull("Message", message);
    }

    public static BiDiSessionStatus fromJson(JsonInput input) {
        boolean ready = false;
        String message = null;
        input.beginObject();
        block8: while (input.hasNext()) {
            switch (input.nextName()) {
                case "ready": {
                    ready = (Boolean)input.read((Type)((Object)Boolean.class));
                    continue block8;
                }
                case "message": {
                    message = (String)input.read((Type)((Object)String.class));
                    continue block8;
                }
            }
            input.skipValue();
        }
        input.endObject();
        return new BiDiSessionStatus(ready, message);
    }

    public boolean isReady() {
        return this.ready;
    }

    public String getMessage() {
        return this.message;
    }

    private Map<String, Object> toJson() {
        TreeMap<String, Object> toReturn = new TreeMap<String, Object>();
        toReturn.put("ready", this.ready);
        toReturn.put("message", this.message);
        return Collections.unmodifiableMap(toReturn);
    }
}

