/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.docker.internal;

import com.google.common.collect.ImmutableSet;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.openqa.selenium.Beta;
import org.openqa.selenium.docker.ImageId;
import org.openqa.selenium.internal.Require;
import org.openqa.selenium.json.JsonInput;
import org.openqa.selenium.json.TypeToken;

@Beta
public class ImageSummary {
    public static final Type LIST_OF_STRING = new TypeToken<List<String>>(){}.getType();
    private final ImageId id;
    private final Set<String> repoTags;

    public ImageSummary(ImageId id, Collection<String> repoTags) {
        this.id = Require.nonNull("Image id", id);
        this.repoTags = ImmutableSet.copyOf(Require.nonNull("Repo tags", repoTags));
    }

    public ImageId getId() {
        return this.id;
    }

    public Set<String> getRepoTags() {
        return this.repoTags;
    }

    static ImageSummary fromJson(JsonInput input) {
        input.beginObject();
        ImageId id = null;
        List<String> repoTags = new ArrayList<String>();
        block8: while (input.hasNext()) {
            switch (input.nextName()) {
                case "Id": {
                    id = new ImageId(input.nextString());
                    continue block8;
                }
                case "RepoTags": {
                    List tags = (List)input.read(LIST_OF_STRING);
                    if (tags == null) continue block8;
                    repoTags = tags;
                    continue block8;
                }
            }
            input.skipValue();
        }
        input.endObject();
        return new ImageSummary(id, repoTags);
    }
}

