/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.grid.config;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSortedSet;
import java.util.Comparator;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import java.util.Set;
import org.openqa.selenium.grid.config.Config;
import org.openqa.selenium.internal.Require;

public class EnvConfig
implements Config {
    @Override
    public Optional<List<String>> getAll(String section, String option) {
        Require.nonNull("Section name", section);
        Require.nonNull("Option name", option);
        String key = String.format("%s_%s", section, option).toUpperCase(Locale.ENGLISH).replace("-", "_").replace(".", "_");
        String value = System.getenv().get(key);
        if (value == null) {
            return Optional.empty();
        }
        if (value.startsWith("$")) {
            value = System.getenv(value.substring(1));
        }
        return Optional.ofNullable(value).map(ImmutableList::of);
    }

    @Override
    public Set<String> getSectionNames() {
        return System.getenv().keySet().stream().filter(key -> key.split("_").length > 1).map(key -> key.substring(0, key.indexOf(95))).map(key -> key.toLowerCase(Locale.ENGLISH)).collect(ImmutableSortedSet.toImmutableSortedSet(Comparator.naturalOrder()));
    }

    @Override
    public Set<String> getOptions(String section) {
        Require.nonNull("Section name to get options for", section);
        String prefix = String.format("%s_", section).toUpperCase(Locale.ENGLISH);
        return System.getenv().keySet().stream().filter(key -> key.startsWith(prefix)).map(key -> key.substring(prefix.length())).map(key -> key.toLowerCase(Locale.ENGLISH)).collect(ImmutableSortedSet.toImmutableSortedSet(Comparator.naturalOrder()));
    }
}

