/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.grid.router;

import java.io.Closeable;
import java.net.URI;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.util.Iterator;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.openqa.selenium.NoSuchSessionException;
import org.openqa.selenium.concurrent.ExecutorServices;
import org.openqa.selenium.concurrent.GuardedRunnable;
import org.openqa.selenium.grid.sessionmap.SessionMap;
import org.openqa.selenium.grid.web.ReverseProxyHandler;
import org.openqa.selenium.internal.Require;
import org.openqa.selenium.remote.ErrorCodec;
import org.openqa.selenium.remote.HttpSessionId;
import org.openqa.selenium.remote.RemoteTags;
import org.openqa.selenium.remote.SessionId;
import org.openqa.selenium.remote.http.ClientConfig;
import org.openqa.selenium.remote.http.Contents;
import org.openqa.selenium.remote.http.HttpClient;
import org.openqa.selenium.remote.http.HttpHandler;
import org.openqa.selenium.remote.http.HttpRequest;
import org.openqa.selenium.remote.http.HttpResponse;
import org.openqa.selenium.remote.tracing.AttributeKey;
import org.openqa.selenium.remote.tracing.AttributeMap;
import org.openqa.selenium.remote.tracing.HttpTracing;
import org.openqa.selenium.remote.tracing.Span;
import org.openqa.selenium.remote.tracing.Status;
import org.openqa.selenium.remote.tracing.Tags;
import org.openqa.selenium.remote.tracing.Tracer;

class HandleSession
implements HttpHandler,
Closeable {
    private static final Logger LOG = Logger.getLogger(HandleSession.class.getName());
    private final Tracer tracer;
    private final HttpClient.Factory httpClientFactory;
    private final SessionMap sessions;
    private final ConcurrentMap<URI, CacheEntry> httpClients;
    private final ScheduledExecutorService cleanUpHttpClientsCacheService;

    HandleSession(Tracer tracer, HttpClient.Factory httpClientFactory, SessionMap sessions) {
        this.tracer = Require.nonNull("Tracer", tracer);
        this.httpClientFactory = Require.nonNull("HTTP client factory", httpClientFactory);
        this.sessions = Require.nonNull("Sessions", sessions);
        this.httpClients = new ConcurrentHashMap<URI, CacheEntry>();
        Runnable cleanUpHttpClients = () -> {
            Instant staleBefore = Instant.now().minus(2L, ChronoUnit.MINUTES);
            Iterator iterator = this.httpClients.values().iterator();
            while (iterator.hasNext()) {
                CacheEntry entry = (CacheEntry)iterator.next();
                if (entry.inUse.get() != 0L) {
                    return;
                }
                if (!entry.lastUse.isBefore(staleBefore)) {
                    return;
                }
                iterator.remove();
                try {
                    entry.httpClient.close();
                }
                catch (Exception ex) {
                    LOG.log(Level.WARNING, "failed to close a stale httpclient", ex);
                }
            }
        };
        this.cleanUpHttpClientsCacheService = Executors.newSingleThreadScheduledExecutor(r -> {
            Thread thread = new Thread(r);
            thread.setDaemon(true);
            thread.setName("HandleSession - Clean up http clients cache");
            return thread;
        });
        this.cleanUpHttpClientsCacheService.scheduleAtFixedRate(GuardedRunnable.guard(cleanUpHttpClients), 1L, 1L, TimeUnit.MINUTES);
    }

    @Override
    public HttpResponse execute(HttpRequest req) {
        try (Span span = HttpTracing.newSpanAsChildOf(this.tracer, req, "router.handle_session");){
            AttributeMap attributeMap = this.tracer.createAttributeMap();
            attributeMap.put(AttributeKey.HTTP_HANDLER_CLASS.getKey(), this.getClass().getName());
            Tags.HTTP_REQUEST.accept(span, req);
            Tags.HTTP_REQUEST_EVENT.accept(attributeMap, req);
            SessionId id = HttpSessionId.getSessionId(req.getUri()).map(SessionId::new).orElseThrow(() -> {
                NoSuchSessionException exception = new NoSuchSessionException("Cannot find session: " + String.valueOf(req));
                Tags.EXCEPTION.accept(attributeMap, exception);
                attributeMap.put(AttributeKey.EXCEPTION_MESSAGE.getKey(), "Unable to execute request for an existing session: " + exception.getMessage());
                span.addEvent(AttributeKey.EXCEPTION_EVENT.getKey(), attributeMap);
                return exception;
            });
            RemoteTags.SESSION_ID.accept(span, id);
            RemoteTags.SESSION_ID_EVENT.accept(attributeMap, id);
            try {
                HttpResponse res;
                HttpTracing.inject(this.tracer, span, req);
                try (Object handler = this.loadSessionId(this.tracer, span, id).call();){
                    res = ((ReverseProxyHandler)handler).execute(req);
                }
                Tags.HTTP_RESPONSE.accept(span, res);
                handler = res;
                return handler;
            }
            catch (Exception e) {
                String errorMessage;
                block21: {
                    span.setAttribute(AttributeKey.ERROR.getKey(), true);
                    span.setStatus(Status.CANCELLED);
                    errorMessage = "Unable to execute request for an existing session: " + e.getMessage();
                    Tags.EXCEPTION.accept(attributeMap, e);
                    attributeMap.put(AttributeKey.EXCEPTION_MESSAGE.getKey(), errorMessage);
                    span.addEvent(AttributeKey.EXCEPTION_EVENT.getKey(), attributeMap);
                    if (!(e instanceof NoSuchSessionException)) break block21;
                    HttpResponse response = new HttpResponse();
                    response.setStatus(404);
                    response.setContent(Contents.asJson(ErrorCodec.createDefault().encode(e)));
                    HttpResponse httpResponse = response;
                    if (span != null) {
                        span.close();
                    }
                    return httpResponse;
                }
                Throwable cause = e.getCause();
                if (cause instanceof RuntimeException) {
                    throw (RuntimeException)cause;
                }
                if (cause != null) {
                    throw new RuntimeException(errorMessage, cause);
                }
                if (e instanceof RuntimeException) {
                    throw (RuntimeException)e;
                }
                throw new RuntimeException(errorMessage, e);
            }
        }
    }

    private Callable<UsageCountingReverseProxyHandler> loadSessionId(Tracer tracer, Span span, SessionId id) {
        return span.wrap(() -> {
            CacheEntry cacheEntry = this.httpClients.compute(this.sessions.getUri(id), (sessionUri, entry) -> {
                if (entry != null) {
                    entry.inUse.incrementAndGet();
                    return entry;
                }
                ClientConfig config = ClientConfig.defaultConfig().baseUri((URI)sessionUri).withRetries();
                HttpClient httpClient = this.httpClientFactory.createClient(config);
                return new CacheEntry(httpClient, 1L);
            });
            try {
                return new UsageCountingReverseProxyHandler(tracer, cacheEntry.httpClient, cacheEntry);
            }
            catch (Throwable t2) {
                cacheEntry.inUse.decrementAndGet();
                throw t2;
            }
        });
    }

    @Override
    public void close() {
        ExecutorServices.shutdownGracefully("HandleSession - Clean up http clients cache", this.cleanUpHttpClientsCacheService);
        this.httpClients.values().removeIf(entry -> {
            entry.httpClient.close();
            return true;
        });
    }

    private static class UsageCountingReverseProxyHandler
    extends ReverseProxyHandler
    implements Closeable {
        private final CacheEntry entry;

        public UsageCountingReverseProxyHandler(Tracer tracer, HttpClient httpClient, CacheEntry entry) {
            super(tracer, httpClient);
            this.entry = entry;
        }

        @Override
        public void close() {
            this.entry.lastUse = Instant.now();
            this.entry.inUse.decrementAndGet();
        }
    }

    private static class CacheEntry {
        private final HttpClient httpClient;
        private final AtomicLong inUse;
        private volatile Instant lastUse;

        public CacheEntry(HttpClient httpClient, long initialUsage) {
            this.httpClient = httpClient;
            this.inUse = new AtomicLong(initialUsage);
            this.lastUse = Instant.now();
        }
    }
}

