/*
 * Decompiled with CFR 0.152.
 */
package org.bytedeco.leptonica;

import java.nio.ByteBuffer;
import org.bytedeco.javacpp.BytePointer;
import org.bytedeco.javacpp.IntPointer;
import org.bytedeco.javacpp.Pointer;
import org.bytedeco.javacpp.annotation.Properties;
import org.bytedeco.javacpp.indexer.Indexable;
import org.bytedeco.javacpp.indexer.UByteIndexer;
import org.bytedeco.leptonica.PIX;
import org.bytedeco.leptonica.global.leptonica;

@Properties(inherit={org.bytedeco.leptonica.presets.leptonica.class})
public abstract class AbstractPIX
extends Pointer
implements Indexable {
    protected IntPointer pointer;

    public AbstractPIX(Pointer p) {
        super(p);
    }

    public static PIX create(int width, int height, int depth) {
        PIX p = leptonica.pixCreate(width, height, depth);
        if (p != null) {
            p.deallocator(new DestroyDeallocator(p));
        }
        return p;
    }

    public static PIX createNoInit(int width, int height, int depth) {
        PIX p = leptonica.pixCreateNoInit(width, height, depth);
        if (p != null) {
            p.deallocator(new DestroyDeallocator(p));
        }
        return p;
    }

    public static PIX createTemplate(PIX pixs) {
        PIX p = leptonica.pixCreateTemplate(pixs);
        if (p != null) {
            p.deallocator(new DestroyDeallocator(p));
        }
        return p;
    }

    public static PIX createTemplateNoInit(PIX pixs) {
        PIX p = leptonica.pixCreateTemplateNoInit(pixs);
        if (p != null) {
            p.deallocator(new DestroyDeallocator(p));
        }
        return p;
    }

    public static PIX createHeader(int width, int height, int depth) {
        PIX p = leptonica.pixCreateHeader(width, height, depth);
        if (p != null) {
            p.deallocator(new DestroyDeallocator(p, true));
        }
        return p;
    }

    public static PIX create(int width, int height, int depth, Pointer data) {
        PIX p = AbstractPIX.createHeader(width, height, depth);
        p.pointer = new IntPointer(data);
        p.data(p.pointer);
        return p;
    }

    public PIX clone() {
        PIX p = new PIX(leptonica.pixClone((PIX)this));
        if (p != null) {
            p.deallocator(new DestroyDeallocator(p));
        }
        return p;
    }

    public ByteBuffer createBuffer() {
        return this.createBuffer(0);
    }

    public ByteBuffer createBuffer(int index) {
        int h = leptonica.pixGetHeight((PIX)this);
        int wpl = leptonica.pixGetWpl((PIX)this);
        BytePointer data = new BytePointer(leptonica.pixGetData((PIX)this)).position(index).capacity(h * wpl * 4);
        return data.asByteBuffer();
    }

    public UByteIndexer createIndexer() {
        return this.createIndexer(true);
    }

    public UByteIndexer createIndexer(boolean direct) {
        int w = leptonica.pixGetWidth((PIX)this);
        int h = leptonica.pixGetHeight((PIX)this);
        int d = leptonica.pixGetDepth((PIX)this);
        int wpl = leptonica.pixGetWpl((PIX)this);
        long[] sizes = new long[]{h, w, d / 8};
        long[] strides = new long[]{wpl * 4, d / 8, 1L};
        BytePointer data = new BytePointer(leptonica.pixGetData((PIX)this)).capacity(h * wpl * 4);
        return UByteIndexer.create(data, sizes, strides, direct);
    }

    public void destroy() {
        this.deallocate();
    }

    protected static class DestroyDeallocator
    extends PIX
    implements Pointer.Deallocator {
        boolean header = false;

        DestroyDeallocator(PIX p) {
            this(p, false);
        }

        DestroyDeallocator(PIX p, boolean header) {
            super(p);
            this.header = header;
        }

        @Override
        public void deallocate() {
            if (this.isNull()) {
                return;
            }
            if (this.header) {
                this.data(null);
            }
            leptonica.pixDestroy(this);
            this.setNull();
        }
    }
}

