/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jmc.flightrecorder.heatmap.views;

import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.text.MessageFormat;
import java.time.Duration;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Stream;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.browser.Browser;
import org.eclipse.swt.browser.ProgressAdapter;
import org.eclipse.swt.browser.ProgressEvent;
import org.eclipse.swt.browser.ProgressListener;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.events.MenuDetectEvent;
import org.eclipse.swt.events.MenuDetectListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.ISelectionListener;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.part.ViewPart;
import org.openjdk.jmc.common.item.IItemCollection;
import org.openjdk.jmc.common.item.ItemCollectionToolkit;
import org.openjdk.jmc.common.util.StringToolkit;
import org.openjdk.jmc.flightrecorder.serializers.json.IItemCollectionJsonSerializer;
import org.openjdk.jmc.flightrecorder.ui.FlightRecorderUI;
import org.openjdk.jmc.ui.common.util.AdapterUtil;
import org.openjdk.jmc.ui.misc.DisplayToolkit;

public class HeatmapView
extends ViewPart
implements ISelectionListener {
    private static final Logger LOGGER = Logger.getLogger(HeatmapView.class.getName());
    private static final String HTML_PAGE;
    private static final int MODEL_EXECUTOR_THREADS_NUMBER = 3;
    private static final ExecutorService MODEL_EXECUTOR;
    private Browser browser;
    private SashForm container;
    private IItemCollection currentItems;
    private volatile ModelState modelState = ModelState.NONE;
    private ModelRebuildRunnable modelRebuildRunnable;

    static {
        String jsD3 = "jslibs/d3.v7.min.js";
        HTML_PAGE = String.format(HeatmapView.loadStringFromFile("page.template"), HeatmapView.loadLibraries(jsD3), HeatmapView.loadStringFromFile("heatmap.js"));
        MODEL_EXECUTOR = Executors.newFixedThreadPool(3, new ThreadFactory(){
            private ThreadGroup group = new ThreadGroup("HeatmapCalculationGroup");
            private AtomicInteger counter = new AtomicInteger();

            @Override
            public Thread newThread(Runnable r) {
                Thread t = new Thread(this.group, r, "HeatmapCalculation-" + this.counter.getAndIncrement());
                t.setDaemon(true);
                return t;
            }
        });
    }

    public void init(IViewSite site, IMemento memento) throws PartInitException {
        super.init(site, memento);
        this.getSite().getPage().addSelectionListener((ISelectionListener)this);
    }

    public void dispose() {
        this.getSite().getPage().removeSelectionListener((ISelectionListener)this);
        super.dispose();
    }

    public void createPartControl(Composite parent) {
        this.container = new SashForm(parent, 256);
        this.browser = new Browser((Composite)this.container, 0);
        this.container.setMaximizedControl((Control)this.browser);
        this.browser.addMenuDetectListener(new MenuDetectListener(){

            public void menuDetected(MenuDetectEvent e) {
                e.doit = false;
            }
        });
    }

    public void setFocus() {
        this.browser.setFocus();
    }

    public void saveState(IMemento memento) {
    }

    public void selectionChanged(IWorkbenchPart part, ISelection selection) {
        if (selection instanceof IStructuredSelection) {
            Object first = ((IStructuredSelection)selection).getFirstElement();
            IItemCollection items = (IItemCollection)AdapterUtil.getAdapter((Object)first, IItemCollection.class);
            if (items == null) {
                this.triggerRebuildTask(ItemCollectionToolkit.build(Stream.empty()));
            } else if (!items.equals(this.currentItems)) {
                this.triggerRebuildTask(items);
            }
        }
    }

    private void triggerRebuildTask(IItemCollection items) {
        if (this.modelRebuildRunnable != null) {
            this.modelRebuildRunnable.setInvalid();
        }
        this.currentItems = items;
        this.modelState = ModelState.NOT_STARTED;
        this.modelRebuildRunnable = new ModelRebuildRunnable(this, items);
        if (!this.modelRebuildRunnable.isInvalid) {
            MODEL_EXECUTOR.execute(this.modelRebuildRunnable);
        }
    }

    private void setModel(IItemCollection items, String eventsJson) {
        if (ModelState.FINISHED.equals((Object)this.modelState) && items.equals(this.currentItems) && !this.browser.isDisposed()) {
            this.setViewerInput(eventsJson);
        }
    }

    private void setViewerInput(final String eventsJson) {
        this.browser.setText(HTML_PAGE);
        this.browser.addProgressListener((ProgressListener)new ProgressAdapter(){
            private boolean loaded = false;

            public void changed(ProgressEvent event) {
                if (this.loaded) {
                    HeatmapView.this.browser.removeProgressListener((ProgressListener)this);
                }
            }

            public void completed(ProgressEvent event) {
                HeatmapView.this.browser.removeProgressListener((ProgressListener)this);
                HeatmapView.this.browser.execute(String.format("updateHeatmap(`%s`);", eventsJson));
                this.loaded = true;
            }
        });
    }

    private static String loadLibraries(String ... libs) {
        if (libs == null || libs.length == 0) {
            return "";
        }
        StringBuilder builder = new StringBuilder(2048);
        String[] stringArray = libs;
        int n = libs.length;
        int n2 = 0;
        while (n2 < n) {
            String lib = stringArray[n2];
            builder.append(HeatmapView.loadStringFromFile(lib));
            builder.append("\n");
            ++n2;
        }
        return builder.toString();
    }

    private static String loadStringFromFile(String fileName) {
        try {
            return StringToolkit.readString((InputStream)HeatmapView.class.getClassLoader().getResourceAsStream(fileName));
        }
        catch (IOException e) {
            FlightRecorderUI.getDefault().getLogger().log(Level.WARNING, MessageFormat.format("Could not load script \"{0}\",\"{1}\"", fileName, e.getMessage()));
            return "";
        }
    }

    public static byte[] readBytes(InputStream in) throws IOException {
        BufferedInputStream bis = new BufferedInputStream(in);
        ByteArrayOutputStream buf = new ByteArrayOutputStream();
        int result = bis.read();
        while (result != -1) {
            buf.write((byte)result);
            result = bis.read();
        }
        return buf.toByteArray();
    }

    private static class ModelRebuildRunnable
    implements Runnable {
        private final HeatmapView view;
        private IItemCollection items;
        private volatile boolean isInvalid;

        private ModelRebuildRunnable(HeatmapView view, IItemCollection items) {
            this.view = view;
            this.items = items;
        }

        private void setInvalid() {
            this.isInvalid = true;
        }

        @Override
        public void run() {
            long start = System.currentTimeMillis();
            Exception exception = null;
            LOGGER.info("starting to create model");
            try {
                this.view.modelState = ModelState.STARTED;
                if (this.isInvalid) {
                    return;
                }
                String eventsJson = IItemCollectionJsonSerializer.toJsonString((IItemCollection)this.items, () -> this.isInvalid);
                if (this.isInvalid) {
                    return;
                }
                try {
                    this.view.modelState = ModelState.FINISHED;
                    DisplayToolkit.inDisplayThread().execute(() -> this.view.setModel(this.items, eventsJson));
                }
                catch (Exception e) {
                    exception = e;
                    throw e;
                }
            }
            finally {
                Duration duration = Duration.ofMillis(System.currentTimeMillis() - start);
                Level level = Level.INFO;
                if (exception != null) {
                    level = Level.SEVERE;
                }
                LOGGER.log(level, "creating model took " + duration + " isInvalid:" + this.isInvalid, exception);
            }
        }
    }

    private static enum ModelState {
        NOT_STARTED,
        STARTED,
        FINISHED,
        NONE;

    }
}

