/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.devtools.v140.audits.model;

import java.util.Objects;
import java.util.Optional;
import org.openqa.selenium.devtools.v140.audits.model.FailedRequestInfo;
import org.openqa.selenium.devtools.v140.audits.model.SourceCodeLocation;
import org.openqa.selenium.devtools.v140.audits.model.StyleSheetLoadingIssueReason;
import org.openqa.selenium.json.JsonInput;

public class StylesheetLoadingIssueDetails {
    private final SourceCodeLocation sourceCodeLocation;
    private final StyleSheetLoadingIssueReason styleSheetLoadingIssueReason;
    private final Optional<FailedRequestInfo> failedRequestInfo;

    public StylesheetLoadingIssueDetails(SourceCodeLocation sourceCodeLocation, StyleSheetLoadingIssueReason styleSheetLoadingIssueReason, Optional<FailedRequestInfo> failedRequestInfo) {
        this.sourceCodeLocation = Objects.requireNonNull(sourceCodeLocation, "sourceCodeLocation is required");
        this.styleSheetLoadingIssueReason = Objects.requireNonNull(styleSheetLoadingIssueReason, "styleSheetLoadingIssueReason is required");
        this.failedRequestInfo = failedRequestInfo;
    }

    public SourceCodeLocation getSourceCodeLocation() {
        return this.sourceCodeLocation;
    }

    public StyleSheetLoadingIssueReason getStyleSheetLoadingIssueReason() {
        return this.styleSheetLoadingIssueReason;
    }

    public Optional<FailedRequestInfo> getFailedRequestInfo() {
        return this.failedRequestInfo;
    }

    private static StylesheetLoadingIssueDetails fromJson(JsonInput input) {
        SourceCodeLocation sourceCodeLocation = null;
        StyleSheetLoadingIssueReason styleSheetLoadingIssueReason = null;
        Optional<FailedRequestInfo> failedRequestInfo = Optional.empty();
        input.beginObject();
        block10: while (input.hasNext()) {
            switch (input.nextName()) {
                case "sourceCodeLocation": {
                    sourceCodeLocation = (SourceCodeLocation)input.read(SourceCodeLocation.class);
                    continue block10;
                }
                case "styleSheetLoadingIssueReason": {
                    styleSheetLoadingIssueReason = (StyleSheetLoadingIssueReason)((Object)input.read(StyleSheetLoadingIssueReason.class));
                    continue block10;
                }
                case "failedRequestInfo": {
                    failedRequestInfo = Optional.ofNullable((FailedRequestInfo)input.read(FailedRequestInfo.class));
                    continue block10;
                }
            }
            input.skipValue();
        }
        input.endObject();
        return new StylesheetLoadingIssueDetails(sourceCodeLocation, styleSheetLoadingIssueReason, failedRequestInfo);
    }
}

