/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.devtools.v140.page.model;

import java.util.Objects;
import java.util.Optional;
import org.openqa.selenium.Beta;
import org.openqa.selenium.json.JsonInput;

@Beta
public class ImageResource {
    private final String url;
    private final Optional<String> sizes;
    private final Optional<String> type;

    public ImageResource(String url, Optional<String> sizes, Optional<String> type) {
        this.url = Objects.requireNonNull(url, "url is required");
        this.sizes = sizes;
        this.type = type;
    }

    public String getUrl() {
        return this.url;
    }

    public Optional<String> getSizes() {
        return this.sizes;
    }

    public Optional<String> getType() {
        return this.type;
    }

    private static ImageResource fromJson(JsonInput input) {
        String url = null;
        Optional<String> sizes = Optional.empty();
        Optional<String> type = Optional.empty();
        input.beginObject();
        block10: while (input.hasNext()) {
            switch (input.nextName()) {
                case "url": {
                    url = input.nextString();
                    continue block10;
                }
                case "sizes": {
                    sizes = Optional.ofNullable(input.nextString());
                    continue block10;
                }
                case "type": {
                    type = Optional.ofNullable(input.nextString());
                    continue block10;
                }
            }
            input.skipValue();
        }
        input.endObject();
        return new ImageResource(url, sizes, type);
    }
}

