/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jfx.incubator.scene.control.richtext;

import java.util.Objects;
import javafx.scene.shape.LineTo;
import javafx.scene.shape.MoveTo;
import javafx.scene.shape.PathElement;

public final class CaretInfo {
    private final double xmin;
    private final double xmax;
    private final double ymin;
    private final double ymax;
    private final double lineSpacing;
    private final PathElement[] path;

    private CaretInfo(double d, double d2, double d3, double d4, double d5, PathElement[] pathElementArray) {
        this.xmin = d;
        this.xmax = d2;
        this.ymin = d3;
        this.ymax = d4;
        this.lineSpacing = d5;
        this.path = pathElementArray;
    }

    public static CaretInfo create(double d, PathElement[] pathElementArray) {
        Objects.requireNonNull(pathElementArray);
        if (pathElementArray.length == 0) {
            throw new IllegalArgumentException("non-empty path is required");
        }
        double d2 = Double.POSITIVE_INFINITY;
        double d3 = Double.NEGATIVE_INFINITY;
        double d4 = Double.POSITIVE_INFINITY;
        double d5 = Double.NEGATIVE_INFINITY;
        int n = pathElementArray.length;
        for (int i = 0; i < n; ++i) {
            double d6;
            double d7;
            PathElement pathElement = pathElementArray[i];
            if (pathElement instanceof LineTo) {
                LineTo lineTo = (LineTo)pathElement;
                d7 = lineTo.getX();
                d6 = lineTo.getY();
                if ((d7 = CaretInfo.halfPixel(d7)) < d2) {
                    d2 = d7;
                } else if (d7 > d3) {
                    d3 = d7;
                }
                d6 = CaretInfo.halfPixel(d6);
                if (d6 < d4) {
                    d4 = d6;
                    continue;
                }
                if (!(d6 > d5)) continue;
                d5 = d6;
                continue;
            }
            if (pathElement instanceof MoveTo) {
                MoveTo moveTo = (MoveTo)pathElement;
                d7 = moveTo.getX();
                d6 = moveTo.getY();
                if ((d7 = CaretInfo.halfPixel(d7)) < d2) {
                    d2 = d7;
                } else if (d7 > d3) {
                    d3 = d7;
                }
                d6 = CaretInfo.halfPixel(d6);
                if (d6 < d4) {
                    d4 = d6;
                    continue;
                }
                if (!(d6 > d5)) continue;
                d5 = d6;
                continue;
            }
            throw new IllegalArgumentException("Unexpected PathElement: " + String.valueOf(pathElement));
        }
        return new CaretInfo(d2, d3, d4, d5, d, pathElementArray);
    }

    public final double getMinX() {
        return this.xmin;
    }

    public final double getMaxX() {
        return this.xmax;
    }

    public final double getMinY() {
        return this.ymin;
    }

    public final double getMaxY() {
        return this.ymax;
    }

    public final double getLineSpacing() {
        return this.lineSpacing;
    }

    public final PathElement[] path() {
        return this.path;
    }

    public final boolean containsY(double d) {
        return d >= this.ymin && d < this.ymax;
    }

    private static double halfPixel(double d) {
        return (double)Math.round(d + 0.5) - 0.5;
    }

    public String toString() {
        return "CaretInfo{xmin=" + this.xmin + ", xmax=" + this.xmax + ", ymin=" + this.ymin + ", ymax=" + this.ymax + "}";
    }
}

