/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jfx.incubator.scene.control.richtext;

import javafx.geometry.HPos;
import javafx.geometry.Insets;
import javafx.geometry.VPos;
import javafx.scene.Node;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javafx.scene.layout.Pane;

public class ImageCellPane
extends Pane {
    private final Image image;
    private final ImageView imageView;
    private static final Insets PADDING = new Insets(1.0, 1.0, 1.0, 1.0);

    public ImageCellPane(Image image) {
        this.image = image;
        this.imageView = new ImageView(image);
        this.imageView.setSmooth(true);
        this.imageView.setPreserveRatio(true);
        this.getChildren().add((Object)this.imageView);
        this.setPadding(PADDING);
        this.getStyleClass().add((Object)"image-cell-pane");
    }

    protected void layoutChildren() {
        double d = this.getWidth();
        double d2 = d < this.image.getWidth() ? d / this.image.getWidth() : 1.0;
        this.imageView.setScaleX(d2);
        this.imageView.setScaleY(d2);
        double d3 = this.snappedLeftInset();
        double d4 = this.snappedTopInset();
        this.layoutInArea((Node)this.imageView, d3, d4, this.image.getWidth() * d2, this.image.getHeight() * d2, 0.0, PADDING, true, false, HPos.CENTER, VPos.CENTER);
    }

    protected double computePrefHeight(double d) {
        double d2 = this.snappedTopInset() + this.snappedBottomInset();
        if (d != -1.0 && d < this.image.getWidth()) {
            return d2 + this.image.getHeight() * d / this.image.getWidth();
        }
        return d2 + this.image.getHeight();
    }
}

