/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jmc.flightrecorder.controlpanel.ui.model;

import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.text.ParseException;
import java.util.Locale;
import java.util.logging.Level;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.openjdk.jmc.flightrecorder.configuration.events.EventConfiguration;
import org.openjdk.jmc.flightrecorder.configuration.events.IEventConfiguration;
import org.openjdk.jmc.flightrecorder.configuration.model.VolatileStorageDelegate;
import org.openjdk.jmc.flightrecorder.configuration.model.xml.XMLModel;
import org.openjdk.jmc.flightrecorder.configuration.spi.IConfigurationStorageDelegate;
import org.openjdk.jmc.flightrecorder.configuration.spi.IStorageProvider;
import org.openjdk.jmc.flightrecorder.controlpanel.ui.ControlPanel;
import org.openjdk.jmc.flightrecorder.controlpanel.ui.model.EventConfigurationRepository;
import org.openjdk.jmc.flightrecorder.controlpanel.ui.model.PrivateStorageDelegate;

public class ConfigurationRepositoryFactory {
    private static final String EXTENSION_POINT = "org.openjdk.jmc.flightrecorder.configuration.storageProvider";
    private static final String EXTENSION_ATTRIBUTE_CLASS = "class";
    private static final String LOWER_CASE_FILE_EXTENSION = ".jfc".toLowerCase();
    private static final String LAST_STARTED_CONFIGURATION_FILE_NAME = "last_started_configuration" + LOWER_CASE_FILE_EXTENSION;
    static final File CONFIGURATION_STORAGE_DIR = ControlPanel.getDefault().getStateLocation().append(".rectemplates").toFile();

    public static EventConfigurationRepository create() {
        EventConfigurationRepository repository = new EventConfigurationRepository();
        ConfigurationRepositoryFactory.initiate(repository);
        return repository;
    }

    protected static void initiate(EventConfigurationRepository repository) {
        ConfigurationRepositoryFactory.addLocalTemplatesTo(repository);
        ConfigurationRepositoryFactory.addContributedTemplatesTo(repository);
        repository.notifyObservers();
    }

    private static void addLocalTemplatesTo(EventConfigurationRepository repository) {
        File localDir = CONFIGURATION_STORAGE_DIR;
        if (!localDir.isDirectory()) {
            return;
        }
        FilenameFilter filter = new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return name.toLowerCase(Locale.ENGLISH).endsWith(LOWER_CASE_FILE_EXTENSION);
            }
        };
        File[] files = localDir.listFiles(filter);
        if (files == null) {
            return;
        }
        File[] fileArray = files;
        int n = files.length;
        int n2 = 0;
        while (n2 < n) {
            File file = fileArray[n2];
            if (file.length() != 0L) {
                try {
                    EventConfiguration template;
                    if (file.getName().equalsIgnoreCase(LAST_STARTED_CONFIGURATION_FILE_NAME)) {
                        XMLModel model = EventConfiguration.createModel((File)file);
                        template = new EventConfiguration(model, VolatileStorageDelegate.getLastStartedDelegate());
                    } else {
                        PrivateStorageDelegate delegate = new PrivateStorageDelegate(file);
                        template = new EventConfiguration((IConfigurationStorageDelegate)delegate);
                    }
                    repository.add((IEventConfiguration)template);
                }
                catch (IOException e) {
                    ControlPanel.getDefault().getLogger().log(Level.SEVERE, "Failed to load local template file " + file, e);
                }
                catch (ParseException e) {
                    ControlPanel.getDefault().getLogger().log(Level.SEVERE, "Failed to parse local template file " + file, e);
                }
            }
            ++n2;
        }
    }

    private static void addContributedTemplatesTo(EventConfigurationRepository repository) {
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        IConfigurationElement[] iConfigurationElementArray = registry.getConfigurationElementsFor(EXTENSION_POINT);
        int n = iConfigurationElementArray.length;
        int n2 = 0;
        while (n2 < n) {
            block6: {
                IConfigurationElement element = iConfigurationElementArray[n2];
                IStorageProvider provider = null;
                try {
                    provider = (IStorageProvider)element.createExecutableExtension(EXTENSION_ATTRIBUTE_CLASS);
                }
                catch (CoreException e) {
                    ControlPanel.getDefault().getLogger().log(Level.WARNING, "Problems when creating IStorageProvider " + element.getName(), e);
                    break block6;
                }
                for (IConfigurationStorageDelegate delegate : provider.getStorageDelegates(LOWER_CASE_FILE_EXTENSION)) {
                    try {
                        EventConfiguration template = new EventConfiguration(delegate);
                        repository.add((IEventConfiguration)template);
                    }
                    catch (IOException | IllegalArgumentException | ParseException e) {
                        ControlPanel.getDefault().getLogger().log(Level.WARNING, "Problems when reading reading from ITemplateStorageDelegate " + delegate.getLocationInfo() + ": " + e.getMessage());
                    }
                }
            }
            ++n2;
        }
    }

    public static File getCreatedStorageDir() throws IOException {
        File dir = CONFIGURATION_STORAGE_DIR;
        if (!dir.isDirectory() && !dir.mkdir()) {
            throw new IOException("Could not create the directory " + dir.toString());
        }
        return dir;
    }

    public static void saveAsLastStarted(IEventConfiguration configuration) {
        try {
            File file = new File(ConfigurationRepositoryFactory.getCreatedStorageDir(), LAST_STARTED_CONFIGURATION_FILE_NAME);
            configuration.exportToFile(file);
        }
        catch (IOException e) {
            ControlPanel.getDefault().getLogger().log(Level.WARNING, "Cannod save last used configuration.", e);
        }
    }
}

