/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jmc.flightrecorder.controlpanel.ui.recordingconfiguration;

import java.util.Objects;
import org.openjdk.jmc.flightrecorder.controlpanel.ui.recordingconfiguration.PropertyContainer;

public abstract class PathElement {
    private final String label;
    private final PropertyContainer m_parent;
    private PathElementKind kind;

    protected PathElement(PropertyContainer parent, String label, PathElementKind kind) {
        this.label = label;
        this.m_parent = parent;
        this.kind = kind;
    }

    public final PropertyContainer getParent() {
        return this.m_parent;
    }

    public final String getName() {
        return this.label;
    }

    protected final void setKind(PathElementKind kind) {
        this.kind = kind;
    }

    protected boolean addKind(PathElementKind kind) {
        PathElementKind newKind = this.kind.add(kind);
        if (newKind != this.kind) {
            this.kind = newKind;
            this.m_parent.addKind(kind);
            return true;
        }
        return false;
    }

    public PathElementKind getKind() {
        return this.kind;
    }

    public int hashCode() {
        return Objects.hash(this.label, this.m_parent);
    }

    public boolean equals(Object obj) {
        if (obj instanceof PathElement) {
            return Objects.equals(this.label, ((PathElement)obj).label) && Objects.equals(this.m_parent, ((PathElement)obj).m_parent);
        }
        return false;
    }

    public String toString() {
        return String.valueOf(this.getClass().getName()) + "@" + this.getName();
    }

    public static final class PathElementKind
    extends Enum<PathElementKind> {
        public static final /* enum */ PathElementKind UNKNOWN = new PathElementKind(0);
        public static final /* enum */ PathElementKind IN_CONFIGURATION = new PathElementKind(1);
        public static final /* enum */ PathElementKind IN_SERVER = new PathElementKind(2);
        public static final /* enum */ PathElementKind IN_BOTH = new PathElementKind(3);
        private static final /* synthetic */ PathElementKind[] ENUM$VALUES;

        static {
            ENUM$VALUES = new PathElementKind[]{UNKNOWN, IN_CONFIGURATION, IN_SERVER, IN_BOTH};
        }

        private PathElementKind(int flags) {
            assert (flags == this.ordinal());
        }

        public boolean contains(PathElementKind otherKind) {
            int otherFlags = otherKind.ordinal();
            return (this.ordinal() & otherFlags) == otherFlags;
        }

        public PathElementKind add(PathElementKind otherKind) {
            return PathElementKind.values()[this.ordinal() | otherKind.ordinal()];
        }

        public static PathElementKind[] values() {
            PathElementKind[] pathElementKindArray = ENUM$VALUES;
            int n = pathElementKindArray.length;
            PathElementKind[] pathElementKindArray2 = new PathElementKind[n];
            System.arraycopy(ENUM$VALUES, 0, pathElementKindArray2, 0, n);
            return pathElementKindArray2;
        }

        public static PathElementKind valueOf(String string) {
            return Enum.valueOf(PathElementKind.class, string);
        }
    }
}

