/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jmc.joverflow.ui;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Stream;
import org.eclipse.swt.custom.StackLayout;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.part.Page;
import org.openjdk.jmc.joverflow.heap.model.JavaClass;
import org.openjdk.jmc.joverflow.heap.model.JavaHeapObject;
import org.openjdk.jmc.joverflow.support.RefChainElement;
import org.openjdk.jmc.joverflow.ui.JOverflowEditor;
import org.openjdk.jmc.joverflow.ui.Messages;
import org.openjdk.jmc.joverflow.ui.TreemapAction;
import org.openjdk.jmc.joverflow.ui.model.ModelListener;
import org.openjdk.jmc.joverflow.ui.model.ObjectCluster;
import org.openjdk.jmc.joverflow.ui.swt.Breadcrumb;
import org.openjdk.jmc.joverflow.ui.swt.BreadcrumbItem;
import org.openjdk.jmc.joverflow.ui.swt.Treemap;
import org.openjdk.jmc.joverflow.ui.swt.TreemapItem;
import org.openjdk.jmc.joverflow.ui.swt.events.TreemapListener;

class TreemapPage
extends Page
implements ModelListener {
    private static final Color[] COLORS = new Color[]{new Color((Device)Display.getCurrent(), 250, 206, 210), new Color((Device)Display.getCurrent(), 185, 214, 255), new Color((Device)Display.getCurrent(), 229, 229, 229), new Color((Device)Display.getCurrent(), 255, 231, 199), new Color((Device)Display.getCurrent(), 171, 235, 238), new Color((Device)Display.getCurrent(), 228, 209, 252), new Color((Device)Display.getCurrent(), 255, 255, 255), new Color((Device)Display.getCurrent(), 205, 249, 212)};
    private static final String LABEL_ROOT = "[ROOT]";
    private final JOverflowEditor editor;
    private final TreemapAction[] treemapActions;
    private Composite container;
    private StackLayout containerLayout;
    private Composite messageContainer;
    private Composite treemapContainer;
    private Label message;
    private Treemap treemap;
    private Breadcrumb breadcrumb;
    private HashMap<String, Double> classes = new HashMap();

    TreemapPage(JOverflowEditor editor, TreemapAction[] treemapActions) {
        this.editor = Objects.requireNonNull(editor);
        this.treemapActions = Objects.requireNonNull(treemapActions);
    }

    public void createControl(Composite parent) {
        this.container = new Composite(parent, 8);
        this.containerLayout = new StackLayout();
        this.container.setLayout((Layout)this.containerLayout);
        this.messageContainer = new Composite(this.container, 0);
        FillLayout layout = new FillLayout();
        layout.marginHeight = 5;
        layout.marginWidth = 5;
        this.messageContainer.setLayout((Layout)layout);
        this.message = new Label(this.messageContainer, 0);
        this.message.setText(Messages.TreemapPage_NO_INSTANCES_SELECTED);
        this.treemapContainer = new Composite(this.container, 0);
        this.treemapContainer.setLayout((Layout)new FormLayout());
        this.breadcrumb = new Breadcrumb(this.treemapContainer, 0);
        FormData bcLayoutData = new FormData();
        bcLayoutData.top = new FormAttachment(0, 0);
        bcLayoutData.left = new FormAttachment(0, 0);
        bcLayoutData.right = new FormAttachment(100, 0);
        this.breadcrumb.setLayoutData(bcLayoutData);
        this.treemap = new Treemap(this.treemapContainer, 0);
        FormData tmLayoutData = new FormData();
        tmLayoutData.bottom = new FormAttachment(100);
        tmLayoutData.top = new FormAttachment((Control)this.breadcrumb);
        tmLayoutData.left = new FormAttachment(0);
        tmLayoutData.right = new FormAttachment(100, 0);
        this.treemap.setLayoutData(tmLayoutData);
        this.treemap.setText(LABEL_ROOT);
        TreemapItem rootItem = this.treemap.getRootItem();
        BreadcrumbItem breadcrumbItem = new BreadcrumbItem(this.breadcrumb, 0);
        breadcrumbItem.setData((Object)rootItem);
        breadcrumbItem.setText(rootItem.getText());
        this.breadcrumb.addSelectionListener(SelectionListener.widgetSelectedAdapter(selectionEvent -> {
            if (!(selectionEvent.data instanceof TreemapItem)) {
                return;
            }
            TreemapItem item = (TreemapItem)((Object)((Object)selectionEvent.data));
            this.treemap.setTopItem(item);
        }));
        this.treemap.addTreemapListener(TreemapListener.treemapTopChangedAdapter(treemapEvent -> {
            TreemapItem item = (TreemapItem)treemapEvent.item;
            this.breadcrumb.removeAll();
            ArrayList<TreemapItem> path = new ArrayList<TreemapItem>();
            do {
                path.add(item);
            } while ((item = item.getParentItem()) != null);
            Collections.reverse(path);
            for (TreemapItem i : path) {
                BreadcrumbItem breadcrumbItem = new BreadcrumbItem(this.breadcrumb, 0);
                breadcrumbItem.setData((Object)i);
                breadcrumbItem.setText(i.getText());
            }
        }));
        this.treemap.addSelectionListener(SelectionListener.widgetSelectedAdapter(selectionEvent -> this.bindTreemapActions()));
        this.treemap.addTreemapListener(TreemapListener.treemapTopChangedAdapter(treemapEvent -> this.bindTreemapActions()));
        this.containerLayout.topControl = this.messageContainer;
        this.updateInput();
    }

    public Control getControl() {
        return this.container;
    }

    public void setFocus() {
        this.getControl().setFocus();
    }

    @Override
    public void include(ObjectCluster cluster, RefChainElement referenceChain) {
        if (cluster.getObjectCount() == 0) {
            return;
        }
        JavaClass clazz = this.getObjectAtPosition(cluster.getGlobalObjectIndex(0)).getClazz();
        String className = clazz.getName();
        if (className.charAt(0) == '[') {
            className = cluster.getClassName();
        }
        this.classes.putIfAbsent(className, 0.0);
        double size = this.classes.get(className);
        this.classes.put(className, size += (double)cluster.getMemory());
    }

    @Override
    public void allIncluded() {
        this.updateInput();
        this.classes.clear();
        this.bindTreemapActions();
    }

    public void bindTreemapActions() {
        if (this.containerLayout == null || this.containerLayout.topControl != this.treemapContainer) {
            Stream.of(this.treemapActions).forEach(action -> action.setEnabled(false));
            return;
        }
        TreemapItem selected = this.treemap.getSelection();
        TreemapItem root = this.treemap.getRootItem();
        TreemapItem top = this.treemap.getTopItem();
        Stream.of(this.treemapActions).forEach(action -> {
            switch (action.getType()) {
                case ZOOM_IN: {
                    action.setEnabled(selected != null && selected != top && (selected.getItemCount() != 0 || selected.getParentItem() != top));
                    action.setRunnable(() -> this.treemap.setTopItem(selected));
                    break;
                }
                case ZOOM_OUT: {
                    action.setEnabled(top.getParentItem() != null);
                    action.setRunnable(() -> this.treemap.setTopItem(top.getParentItem()));
                    break;
                }
                case ZOOM_RESET: {
                    action.setEnabled(top != root);
                    action.setRunnable(() -> this.treemap.setTopItem(root));
                }
            }
        });
    }

    private void updateInput() {
        if (this.classes.size() == 0) {
            this.containerLayout.topControl = this.messageContainer;
            this.container.layout();
            return;
        }
        if (this.treemap == null) {
            return;
        }
        this.treemap.removeAll();
        HashMap<String, TreemapItem> items = new HashMap<String, TreemapItem>();
        for (Map.Entry<String, Double> entry : this.classes.entrySet()) {
            this.addTreemapItem(this.treemap, items, entry.getKey(), entry.getValue());
        }
        TreemapItem rootItem = this.treemap.getRootItem();
        rootItem.setToolTipText(LABEL_ROOT);
        this.setColorAndToolTip(rootItem, 0);
        this.treemap.setTopItem(rootItem);
        this.treemap.setSelection(null);
        this.containerLayout.topControl = this.treemapContainer;
        this.container.layout();
    }

    private void addTreemapItem(Treemap parent, Map<String, TreemapItem> items, String fullName, double size) {
        if (items.containsKey(fullName) && size != 0.0) {
            TreemapItem item = items.get(fullName);
            double bytes = item.getWeight() + size;
            item.setWeight(bytes);
            item.setToolTipText(fullName);
            return;
        }
        if (fullName.indexOf(46) == -1) {
            TreemapItem item = new TreemapItem(parent, 0);
            item.setText(fullName);
            if (size != 0.0) {
                item.setWeight(size);
            }
            item.setToolTipText(fullName);
            items.put(fullName, item);
            return;
        }
        String parentName = fullName.substring(0, fullName.lastIndexOf(46));
        if (!items.containsKey(parentName)) {
            this.addTreemapItem(parent, items, parentName, 0.0);
        }
        TreemapItem parentItem = items.get(parentName);
        TreemapItem item = new TreemapItem(parentItem, 0);
        item.setText(fullName.substring(parentName.length() + 1));
        item.setToolTipText(fullName);
        if (size != 0.0) {
            item.setWeight(size);
        }
        items.put(fullName, item);
    }

    private void setColorAndToolTip(TreemapItem item, int depth) {
        item.setToolTipText(String.valueOf(item.getToolTipText()) + "\n" + this.getHumanReadableSize(item.getWeight()));
        item.setBackground(COLORS[depth % COLORS.length]);
        TreemapItem[] treemapItemArray = item.getItems();
        int n = treemapItemArray.length;
        int n2 = 0;
        while (n2 < n) {
            TreemapItem child = treemapItemArray[n2];
            this.setColorAndToolTip(child, depth + 1);
            ++n2;
        }
    }

    private String getHumanReadableSize(double bytes) {
        String unit = "B";
        double quantity = bytes;
        if (quantity > 1024.0) {
            quantity /= 1024.0;
            unit = "KiB";
        }
        if (quantity > 1024.0) {
            quantity /= 1024.0;
            unit = "MiB";
        }
        if (quantity > 1024.0) {
            quantity /= 1024.0;
            unit = "GiB";
        }
        if (quantity > 1024.0) {
            quantity /= 1024.0;
            unit = "TiB";
        }
        return String.format("%.2f %s", quantity, unit);
    }

    private JavaHeapObject getObjectAtPosition(int globalObjectPos) {
        return this.editor.getSnapshot().getObjectAtGlobalIndex(globalObjectPos);
    }
}

