/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jmc.flightrecorder.rules.jdk.agent;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.FutureTask;
import java.util.concurrent.RunnableFuture;
import org.openjdk.jmc.common.item.Aggregators;
import org.openjdk.jmc.common.item.IItemCollection;
import org.openjdk.jmc.common.item.ItemFilters;
import org.openjdk.jmc.common.unit.ContentType;
import org.openjdk.jmc.common.unit.IPersister;
import org.openjdk.jmc.common.unit.IQuantity;
import org.openjdk.jmc.common.unit.IUnit;
import org.openjdk.jmc.common.unit.QuantitiesToolkit;
import org.openjdk.jmc.common.unit.UnitLookup;
import org.openjdk.jmc.common.util.IPreferenceValueProvider;
import org.openjdk.jmc.common.util.TypedPreference;
import org.openjdk.jmc.flightrecorder.rules.IResult;
import org.openjdk.jmc.flightrecorder.rules.IResultValueProvider;
import org.openjdk.jmc.flightrecorder.rules.IRule;
import org.openjdk.jmc.flightrecorder.rules.ResultBuilder;
import org.openjdk.jmc.flightrecorder.rules.Severity;
import org.openjdk.jmc.flightrecorder.rules.TypedResult;
import org.openjdk.jmc.flightrecorder.rules.jdk.messages.internal.Messages;
import org.openjdk.jmc.flightrecorder.rules.util.RulesToolkit;

public class MultipleAgentsRule
implements IRule {
    private static final String MULTIPLE_AGENTS_RESULT_ID = "MultipleAgents";
    public static final TypedPreference<IQuantity> JAVA_WARNING_LIMIT = new TypedPreference("agents.muliple.java.warning.limit", Messages.getString("MultipleAgentsRule_JAVA_WARNING_LIMIT"), Messages.getString("MultipleAgentsRule_JAVA_WARNING_LIMIT_LONG"), (IPersister)UnitLookup.NUMBER, (Object)UnitLookup.NUMBER_UNITY.quantity(1L));
    public static final TypedPreference<IQuantity> NATIVE_WARNING_LIMIT = new TypedPreference("agents.muliple.native.warning.limit", Messages.getString("MultipleAgentsRule_NATIVE_WARNING_LIMIT"), Messages.getString("MultipleAgentsRule_NATIVE_WARNING_LIMIT_LONG"), (IPersister)UnitLookup.NUMBER, (Object)UnitLookup.NUMBER_UNITY.quantity(1L));
    private static final List<TypedPreference<?>> CONFIG_ATTRIBUTES = Arrays.asList(JAVA_WARNING_LIMIT, NATIVE_WARNING_LIMIT);
    private static final Map<String, RulesToolkit.EventAvailability> REQUIRED_EVENTS = RulesToolkit.RequiredEventsBuilder.create().addEventType("jdk.JavaAgent", RulesToolkit.EventAvailability.ENABLED).addEventType("jdk.NativeAgent", RulesToolkit.EventAvailability.ENABLED).build();
    public static final TypedResult<IQuantity> JAVA_AGENT_COUNT = new TypedResult("javaAgentCount", "Java Agent Count", "The number of active Java Agents.", (ContentType)UnitLookup.NUMBER, IQuantity.class);
    public static final TypedResult<IQuantity> NATIVE_AGENT_COUNT = new TypedResult("nativeAgentCount", "Native Agent Count", "The number of active Native Agents.", (ContentType)UnitLookup.TIMESTAMP, IQuantity.class);
    public static final TypedResult<IQuantity> TOTAL_AGENT_COUNT = new TypedResult("totalAgentCount", "Total Agent Count", "The total number of active Agents.", (ContentType)UnitLookup.TIMESTAMP, IQuantity.class);
    private static final Collection<TypedResult<?>> RESULT_ATTRIBUTES = Arrays.asList(TypedResult.SCORE, JAVA_AGENT_COUNT, NATIVE_AGENT_COUNT, TOTAL_AGENT_COUNT);

    private IResult getResult(IItemCollection items, IPreferenceValueProvider valueProvider, IResultValueProvider resultProvider) {
        IQuantity javaCountQuantity = QuantitiesToolkit.nullSafe((IQuantity)((IQuantity)items.apply(ItemFilters.type((String)"jdk.JavaAgent")).getAggregate(Aggregators.count())));
        IQuantity nativeCountQuantity = QuantitiesToolkit.nullSafe((IQuantity)((IQuantity)items.apply(ItemFilters.type((String)"jdk.NativeAgent")).getAggregate(Aggregators.count())));
        IQuantity totalCountQuantity = javaCountQuantity.add(nativeCountQuantity);
        long javaWarningLimit = ((IQuantity)valueProvider.getPreferenceValue(JAVA_WARNING_LIMIT)).clampedFloorIn((IUnit)UnitLookup.NUMBER_UNITY);
        long nativeWarningLimit = ((IQuantity)valueProvider.getPreferenceValue(JAVA_WARNING_LIMIT)).clampedFloorIn((IUnit)UnitLookup.NUMBER_UNITY);
        long javaCount = javaCountQuantity.longValue();
        long nativeCount = nativeCountQuantity.longValue();
        if (javaCount > javaWarningLimit || nativeCount > nativeWarningLimit) {
            return ResultBuilder.createFor((IRule)this, (IPreferenceValueProvider)valueProvider).setSeverity(Severity.WARNING).setSummary(Messages.getString("MultipleAgentsRule_TEXT_SUMMARY")).setExplanation(Messages.getString("MultipleAgentsRule_TEXT_EXPLANATION")).setSolution(Messages.getString("MultipleAgentsRule_TEXT_SOLUTION")).addResult(JAVA_AGENT_COUNT, (Object)javaCountQuantity).addResult(NATIVE_AGENT_COUNT, (Object)nativeCountQuantity).addResult(TOTAL_AGENT_COUNT, (Object)totalCountQuantity).addResult(TypedResult.SCORE, (Object)UnitLookup.NUMBER_UNITY.quantity(55L)).build();
        }
        return ResultBuilder.createFor((IRule)this, (IPreferenceValueProvider)valueProvider).setSeverity(Severity.OK).setSummary(Messages.getString("MultipleAgentsRule_TEXT_OK")).addResult(JAVA_AGENT_COUNT, (Object)javaCountQuantity).addResult(NATIVE_AGENT_COUNT, (Object)nativeCountQuantity).addResult(TOTAL_AGENT_COUNT, (Object)totalCountQuantity).build();
    }

    public RunnableFuture<IResult> createEvaluation(final IItemCollection items, final IPreferenceValueProvider valueProvider, final IResultValueProvider resultProvider) {
        FutureTask<IResult> evaluationTask = new FutureTask<IResult>(new Callable<IResult>(){

            @Override
            public IResult call() throws Exception {
                return MultipleAgentsRule.this.getResult(items, valueProvider, resultProvider);
            }
        });
        return evaluationTask;
    }

    public Collection<TypedPreference<?>> getConfigurationAttributes() {
        return CONFIG_ATTRIBUTES;
    }

    public String getId() {
        return MULTIPLE_AGENTS_RESULT_ID;
    }

    public String getName() {
        return Messages.getString("MultipleAgentsRule_RULE_NAME");
    }

    public String getTopic() {
        return "agent_information";
    }

    public Map<String, RulesToolkit.EventAvailability> getRequiredEvents() {
        return REQUIRED_EVENTS;
    }

    public Collection<TypedResult<?>> getResults() {
        return RESULT_ATTRIBUTES;
    }
}

