/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jmc.flightrecorder.rules.jdk.cpu;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.FutureTask;
import java.util.concurrent.RunnableFuture;
import org.openjdk.jmc.common.collection.MapToolkit;
import org.openjdk.jmc.common.item.IAccessorFactory;
import org.openjdk.jmc.common.item.IItemCollection;
import org.openjdk.jmc.common.unit.ContentType;
import org.openjdk.jmc.common.unit.IPersister;
import org.openjdk.jmc.common.unit.IQuantity;
import org.openjdk.jmc.common.unit.IUnit;
import org.openjdk.jmc.common.unit.UnitLookup;
import org.openjdk.jmc.common.util.IPreferenceValueProvider;
import org.openjdk.jmc.common.util.TypedPreference;
import org.openjdk.jmc.flightrecorder.JfrAttributes;
import org.openjdk.jmc.flightrecorder.jdk.JdkFilters;
import org.openjdk.jmc.flightrecorder.rules.IResult;
import org.openjdk.jmc.flightrecorder.rules.IResultValueProvider;
import org.openjdk.jmc.flightrecorder.rules.IRule;
import org.openjdk.jmc.flightrecorder.rules.ResultBuilder;
import org.openjdk.jmc.flightrecorder.rules.Severity;
import org.openjdk.jmc.flightrecorder.rules.TypedResult;
import org.openjdk.jmc.flightrecorder.rules.jdk.messages.internal.Messages;
import org.openjdk.jmc.flightrecorder.rules.util.RulesToolkit;

public class ManyRunningProcessesRule
implements IRule {
    private static final String MANY_RUNNING_PROCESSES_RESULT_ID = "ManyRunningProcesses";
    public static final TypedPreference<IQuantity> OTHER_PROCESSES_INFO_LIMIT = new TypedPreference("other.processes.info.limit", Messages.getString("ManyRunningProcessesRule_INFO_LIMIT"), Messages.getString("ManyRunningProcessesRule_INFO_LIMIT_LONG"), (IPersister)UnitLookup.NUMBER, (Object)UnitLookup.NUMBER_UNITY.quantity(150L));
    private static final List<TypedPreference<?>> CONFIG_ATTRIBUTES = Arrays.asList(OTHER_PROCESSES_INFO_LIMIT);
    private static final Map<String, RulesToolkit.EventAvailability> REQUIRED_EVENTS = RulesToolkit.RequiredEventsBuilder.create().addEventType("jdk.SystemProcess", RulesToolkit.EventAvailability.AVAILABLE).build();
    public static final TypedResult<IQuantity> COMPETING_PROCESS_COUNT = new TypedResult("competingProcessCount", "Competing Process Count", "The number of other processes running at the same time on the same system.", (ContentType)UnitLookup.NUMBER, IQuantity.class);
    public static final TypedResult<IQuantity> COMPETING_PROCESS_TIME = new TypedResult("competingProcessTime", "Competing Process Time", "The timestamp when the number of competing processes was at the maximum.", (ContentType)UnitLookup.TIMESTAMP, IQuantity.class);
    private static final Collection<TypedResult<?>> RESULT_ATTRIBUTES = Arrays.asList(COMPETING_PROCESS_COUNT, COMPETING_PROCESS_TIME);

    private IResult getResult(IItemCollection items, IPreferenceValueProvider vp, IResultValueProvider rp) {
        List entries = RulesToolkit.calculateGroupingScore((IItemCollection)items.apply(JdkFilters.PROCESSES), (IAccessorFactory)JfrAttributes.END_TIME);
        if (entries.size() > 0) {
            MapToolkit.IntEntry maxNumberProcesses = (MapToolkit.IntEntry)entries.get(entries.size() - 1);
            double score = RulesToolkit.mapExp74((double)maxNumberProcesses.getValue(), (double)((IQuantity)vp.getPreferenceValue(OTHER_PROCESSES_INFO_LIMIT)).clampedFloorIn((IUnit)UnitLookup.NUMBER_UNITY));
            return ResultBuilder.createFor((IRule)this, (IPreferenceValueProvider)vp).setSeverity(Severity.get((double)score)).setSummary(Messages.getString("ManyRunningProcessesRule_TEXT_INFO")).setExplanation(Messages.getString("ManyRunningProcessesRule_TEXT_INFO_LONG")).setSolution(Messages.getString("ManyRunningProcessesRule_TEXT_RECOMMENDATION")).addResult(TypedResult.SCORE, (Object)UnitLookup.NUMBER_UNITY.quantity(score)).addResult(COMPETING_PROCESS_COUNT, (Object)UnitLookup.NUMBER_UNITY.quantity((long)maxNumberProcesses.getValue())).addResult(COMPETING_PROCESS_TIME, (Object)((IQuantity)maxNumberProcesses.getKey())).build();
        }
        return ResultBuilder.createFor((IRule)this, (IPreferenceValueProvider)vp).setSeverity(Severity.NA).build();
    }

    public RunnableFuture<IResult> createEvaluation(final IItemCollection items, final IPreferenceValueProvider valueProvider, final IResultValueProvider resultProvider) {
        FutureTask<IResult> evaluationTask = new FutureTask<IResult>(new Callable<IResult>(){

            @Override
            public IResult call() throws Exception {
                return ManyRunningProcessesRule.this.getResult(items, valueProvider, resultProvider);
            }
        });
        return evaluationTask;
    }

    public Collection<TypedPreference<?>> getConfigurationAttributes() {
        return CONFIG_ATTRIBUTES;
    }

    public String getId() {
        return MANY_RUNNING_PROCESSES_RESULT_ID;
    }

    public String getName() {
        return Messages.getString("ManyRunningProcessesRule_RULE_NAME");
    }

    public String getTopic() {
        return "processes";
    }

    public Map<String, RulesToolkit.EventAvailability> getRequiredEvents() {
        return REQUIRED_EVENTS;
    }

    public Collection<TypedResult<?>> getResults() {
        return RESULT_ATTRIBUTES;
    }
}

