/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jmc.flightrecorder.rules.jdk.dataproviders;

import org.openjdk.jmc.common.item.IItem;
import org.openjdk.jmc.common.item.IItemCollection;
import org.openjdk.jmc.common.item.IItemFilter;
import org.openjdk.jmc.common.item.IItemIterable;
import org.openjdk.jmc.common.unit.IQuantity;
import org.openjdk.jmc.common.unit.IRange;
import org.openjdk.jmc.common.unit.ITypedQuantity;
import org.openjdk.jmc.common.unit.QuantityRange;
import org.openjdk.jmc.common.unit.UnitLookup;
import org.openjdk.jmc.flightrecorder.jdk.JdkAggregators;
import org.openjdk.jmc.flightrecorder.jdk.JdkFilters;
import org.openjdk.jmc.flightrecorder.rules.tree.ITreeNode;
import org.openjdk.jmc.flightrecorder.rules.tree.ItemTreeBuilder;
import org.openjdk.jmc.flightrecorder.rules.util.RulesToolkit;
import org.openjdk.jmc.flightrecorder.rules.util.SlidingWindowToolkit;

public class HaltsProvider {
    public static IQuantity calculateGcPauseRatio(IItemCollection items) {
        IRange<IQuantity> itemRange = HaltsProvider.createRange(items);
        return HaltsProvider.calculateHaltsRatio(items, (IQuantity)items.getAggregate(JdkAggregators.TOTAL_GC_PAUSE), (IQuantity)itemRange.getStart(), (IQuantity)itemRange.getEnd());
    }

    public static IQuantity calculateGcHaltsRatio(IItemCollection items, IQuantity startTime, IQuantity endTime) {
        return HaltsProvider.calculateHaltsRatio(items, HaltsProvider.calculatePauseSum(items, JdkFilters.GC_PAUSE, startTime, endTime), startTime, endTime);
    }

    public static ApplicationHaltsInfoHolder calculateApplicationHaltsRatio(IItemCollection items) {
        IRange<IQuantity> itemRange = HaltsProvider.createRange(items);
        return HaltsProvider.calculateHaltsRatiosWithEncapsulationTree(items, (IQuantity)itemRange.getStart(), (IQuantity)itemRange.getEnd());
    }

    private static ApplicationHaltsInfoHolder calculateHaltsRatiosWithEncapsulationTree(IItemCollection items, IQuantity startTime, IQuantity endTime) {
        IItemFilter haltsFilter = JdkFilters.APPLICATION_PAUSES;
        IItemFilter gcFilter = JdkFilters.GC_PAUSE;
        IItemFilter safepointFilter = JdkFilters.SAFE_POINTS;
        IQuantity haltsDuration = HaltsProvider.calculatePauseSumWithEncapsulationTree(items, haltsFilter, startTime, endTime);
        IQuantity gcDuration = HaltsProvider.calculatePauseSum(items, gcFilter, startTime, endTime);
        IQuantity safepointDuration = HaltsProvider.calculatePauseSum(items, safepointFilter, startTime, endTime);
        IQuantity haltsRatio = HaltsProvider.calculateHaltsRatio(items, haltsDuration, startTime, endTime);
        IQuantity gcRatio = HaltsProvider.calculateHaltsRatio(items, gcDuration, startTime, endTime);
        IQuantity safepointRatio = HaltsProvider.calculateHaltsRatio(items, safepointDuration, startTime, endTime);
        return new ApplicationHaltsInfoHolder(gcRatio, safepointRatio, haltsRatio);
    }

    private static IQuantity calculateHaltsRatio(IItemCollection items, IQuantity pauseTime, IQuantity startTime, IQuantity endTime) {
        IRange range = QuantityRange.createWithEnd((IQuantity)startTime, (IQuantity)endTime);
        IQuantity totalTime = (IQuantity)range.getExtent();
        if (pauseTime != null) {
            return RulesToolkit.toRatioPercent((IQuantity)pauseTime, (IQuantity)totalTime);
        }
        return UnitLookup.PERCENT.quantity(0L);
    }

    private static IQuantity calculatePauseSum(IItemCollection items, IItemFilter pauseFilter, IQuantity startTime, IQuantity endTime) {
        IItemCollection pauses = items.apply(pauseFilter);
        ITypedQuantity pauseTime = UnitLookup.NANOSECOND.quantity(0L);
        for (IItemIterable ii : pauses) {
            for (IItem item : ii) {
                pauseTime = pauseTime.add(RulesToolkit.getDurationInWindow((IQuantity)startTime, (IQuantity)endTime, (IItem)item));
            }
        }
        return pauseTime;
    }

    private static IQuantity calculatePauseSumWithEncapsulationTree(IItemCollection items, IItemFilter haltsFilter, IQuantity startTime, IQuantity endTime) {
        IItemCollection filteredCollection = items.apply(haltsFilter);
        ITreeNode root = ItemTreeBuilder.buildEncapsulationTree((IItemCollection)filteredCollection, (boolean)false, (boolean)true);
        ITypedQuantity totalDuration = UnitLookup.NANOSECOND.quantity(0L);
        for (ITreeNode child : root.getChildren()) {
            IQuantity childDuration = RulesToolkit.getDurationInWindow((IQuantity)startTime, (IQuantity)endTime, (IItem)((IItem)child.getValue()));
            totalDuration = totalDuration.add(childDuration);
        }
        return totalDuration;
    }

    private static IRange<IQuantity> createRange(IItemCollection items) {
        IQuantity start = RulesToolkit.getEarliestStartTime((IItemCollection)items);
        IQuantity end = RulesToolkit.getLatestEndTime((IItemCollection)items);
        return start != null && end != null ? QuantityRange.createWithEnd((IQuantity)start, (IQuantity)end) : null;
    }

    public static SlidingWindowToolkit.IUnorderedWindowValueFunction<IQuantity> gcHaltsRatioFunction() {
        return new SlidingWindowToolkit.IUnorderedWindowValueFunction<IQuantity>(){

            public IQuantity getValue(IItemCollection items, IQuantity startTime, IQuantity endTime) {
                return HaltsProvider.calculateGcHaltsRatio(items, startTime, endTime);
            }
        };
    }

    public static SlidingWindowToolkit.IUnorderedWindowValueFunction<ApplicationHaltsInfoHolder> applicationHaltsRatioFunction() {
        return new SlidingWindowToolkit.IUnorderedWindowValueFunction<ApplicationHaltsInfoHolder>(){

            public ApplicationHaltsInfoHolder getValue(IItemCollection items, IQuantity startTime, IQuantity endTime) {
                return HaltsProvider.calculateHaltsRatiosWithEncapsulationTree(items, startTime, endTime);
            }
        };
    }

    public static class ApplicationHaltsInfoHolder {
        private final IQuantity gcPauseRatio;
        private final IQuantity safePointRatio;
        private final IQuantity totalHaltsRatio;
        private final IQuantity nonGcHaltsRatio;
        private final IQuantity nonGcHaltsToTotalRatio;

        ApplicationHaltsInfoHolder(IQuantity gcPauseRatio, IQuantity safePointRatio, IQuantity totalHaltsRatio) {
            this.gcPauseRatio = gcPauseRatio;
            this.safePointRatio = safePointRatio;
            this.totalHaltsRatio = totalHaltsRatio;
            this.nonGcHaltsRatio = totalHaltsRatio.subtract(gcPauseRatio);
            this.nonGcHaltsToTotalRatio = totalHaltsRatio.doubleValue() == 0.0 ? UnitLookup.PERCENT.quantity(0L) : RulesToolkit.toRatioPercent((IQuantity)this.nonGcHaltsRatio, (IQuantity)totalHaltsRatio);
        }

        public IQuantity getGcPauseRatio() {
            return this.gcPauseRatio;
        }

        public IQuantity getSafePointRatio() {
            return this.safePointRatio;
        }

        public IQuantity getTotalHaltsRatio() {
            return this.totalHaltsRatio;
        }

        public IQuantity getNonGcHaltsRatio() {
            return this.nonGcHaltsRatio;
        }

        public IQuantity getNonGcHaltsToTotalRatio() {
            return this.nonGcHaltsToTotalRatio;
        }
    }
}

