/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jmc.flightrecorder.rules.jdk.general;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.FutureTask;
import java.util.concurrent.RunnableFuture;
import org.openjdk.jmc.common.item.IAttribute;
import org.openjdk.jmc.common.item.IItemCollection;
import org.openjdk.jmc.common.unit.ContentType;
import org.openjdk.jmc.common.unit.IPersister;
import org.openjdk.jmc.common.unit.IQuantity;
import org.openjdk.jmc.common.unit.ITypedQuantity;
import org.openjdk.jmc.common.unit.IUnit;
import org.openjdk.jmc.common.unit.UnitLookup;
import org.openjdk.jmc.common.util.IPreferenceValueProvider;
import org.openjdk.jmc.common.util.TypedPreference;
import org.openjdk.jmc.flightrecorder.JfrAttributes;
import org.openjdk.jmc.flightrecorder.jdk.JdkAggregators;
import org.openjdk.jmc.flightrecorder.jdk.JdkFilters;
import org.openjdk.jmc.flightrecorder.jdk.JdkQueries;
import org.openjdk.jmc.flightrecorder.rules.IResult;
import org.openjdk.jmc.flightrecorder.rules.IResultValueProvider;
import org.openjdk.jmc.flightrecorder.rules.IRule;
import org.openjdk.jmc.flightrecorder.rules.ResultBuilder;
import org.openjdk.jmc.flightrecorder.rules.Severity;
import org.openjdk.jmc.flightrecorder.rules.TypedResult;
import org.openjdk.jmc.flightrecorder.rules.jdk.messages.internal.Messages;
import org.openjdk.jmc.flightrecorder.rules.util.RulesToolkit;

public class BufferLostRule
implements IRule {
    private static final String BUFFER_LOST_RESULT_ID = "BufferLost";
    public static final TypedPreference<IQuantity> WARNING_LIMIT = new TypedPreference("bufferlost.warning.limit", Messages.getString("BufferLostRuleFactory_CONFIG_WARN_LIMIT"), Messages.getString("BufferLostRuleFactory_CONFIG_WARN_LIMIT_LONG"), (IPersister)UnitLookup.NUMBER, (Object)UnitLookup.NUMBER_UNITY.quantity(1L));
    public static final TypedResult<IQuantity> DROPPED_COUNT = new TypedResult("droppedCount", Messages.getString("BufferLostRuleFactory_RESULT_DROPPED_COUNT_NAME"), Messages.getString("BufferLostRuleFactory_RESULT_DROPPED_COUNT_DESCRIPTION"), (ContentType)UnitLookup.NUMBER, IQuantity.class);
    public static final TypedResult<IQuantity> DROPPED_SIZE = new TypedResult("droppedSize", Messages.getString("BufferLostRuleFactory_RESULT_DROPPED_SIZE_NAME"), Messages.getString("BufferLostRuleFactory_RESULT_DROPPED_SIZE_DESCRIPTION"), (ContentType)UnitLookup.MEMORY, IQuantity.class);
    public static final TypedResult<IQuantity> FIRST_DROPPED_BUFFER_TIME = new TypedResult("firstDroppedBufferTime", Messages.getString("BufferLostRuleFactory_RESULT_FIRST_DROPPED_BUFFER_TIME_NAME"), Messages.getString("BufferLostRuleFactory_RESULT_FIRST_DROPPED_BUFFER_TIME_DESCRIPTION"), (ContentType)UnitLookup.TIMESTAMP, IQuantity.class);
    private static final List<TypedPreference<?>> CONFIG_ATTRIBUTES = Arrays.asList(WARNING_LIMIT);
    private static final List<TypedResult<?>> RESULT_ATTRIBUTES = Arrays.asList(TypedResult.SCORE, DROPPED_COUNT, DROPPED_SIZE, FIRST_DROPPED_BUFFER_TIME);

    public String getId() {
        return BUFFER_LOST_RESULT_ID;
    }

    public String getTopic() {
        return "recording";
    }

    public String getName() {
        return Messages.getString("BufferLostRuleFactory_RULE_NAME");
    }

    public Map<String, RulesToolkit.EventAvailability> getRequiredEvents() {
        return Collections.emptyMap();
    }

    private IResult getResult(IItemCollection items, IPreferenceValueProvider valueProvider, IResultValueProvider resultValueProvider) {
        IQuantity limit = (IQuantity)valueProvider.getPreferenceValue(WARNING_LIMIT);
        IItemCollection filtered = items.apply(JdkFilters.JFR_DATA_LOST);
        IQuantity startTime = (IQuantity)filtered.getAggregate(JdkAggregators.first((IAttribute)JfrAttributes.START_TIME));
        if (startTime != null) {
            IQuantity droppedCount = (IQuantity)filtered.getAggregate(JdkAggregators.JFR_DATA_LOST_COUNT);
            IQuantity droppedSize = (IQuantity)filtered.getAggregate(JdkAggregators.FLR_DATA_LOST_SIZE);
            double rawScore = this.calculateScore(limit, droppedCount);
            ITypedQuantity score = UnitLookup.NUMBER_UNITY.quantity(rawScore);
            return ResultBuilder.createFor((IRule)this, (IPreferenceValueProvider)valueProvider).setSeverity(Severity.get((double)rawScore)).addResult(TypedResult.SCORE, (Object)score).addResult(DROPPED_COUNT, (Object)droppedCount).addResult(DROPPED_SIZE, (Object)droppedSize).addResult(FIRST_DROPPED_BUFFER_TIME, (Object)startTime).addResult(TypedResult.ITEM_QUERY, (Object)JdkQueries.JFR_DATA_LOST).setSummary(Messages.getString("BufferLostRuleFactory_RESULT_SUMMARY")).setExplanation(Messages.getString("BufferLostRuleFactory_RESULT_EXPLANATION")).setSolution(Messages.getString("BufferLostRuleFactory_RESULT_SOLUTION")).build();
        }
        return ResultBuilder.createFor((IRule)this, (IPreferenceValueProvider)valueProvider).setSeverity(Severity.OK).setSummary(Messages.getString("BufferLostRuleFactory_RESULT_SUMMARY_OK")).build();
    }

    private double calculateScore(IQuantity limit, IQuantity droppedCount) {
        return RulesToolkit.mapExp100((double)limit.clampedLongValueIn((IUnit)UnitLookup.NUMBER_UNITY), (double)droppedCount.longValue());
    }

    public RunnableFuture<IResult> createEvaluation(final IItemCollection items, final IPreferenceValueProvider preferenceValueProvider, final IResultValueProvider dependencyResults) {
        FutureTask<IResult> evaluationTask = new FutureTask<IResult>(new Callable<IResult>(){

            @Override
            public IResult call() throws Exception {
                return BufferLostRule.this.getResult(items, preferenceValueProvider, dependencyResults);
            }
        });
        return evaluationTask;
    }

    public Collection<TypedPreference<?>> getConfigurationAttributes() {
        return CONFIG_ATTRIBUTES;
    }

    public Collection<TypedResult<?>> getResults() {
        return RESULT_ATTRIBUTES;
    }
}

