/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jmc.flightrecorder.rules.jdk.general;

import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.FutureTask;
import java.util.concurrent.RunnableFuture;
import org.openjdk.jmc.common.item.IItemCollection;
import org.openjdk.jmc.common.util.IPreferenceValueProvider;
import org.openjdk.jmc.common.util.TypedPreference;
import org.openjdk.jmc.flightrecorder.jdk.JdkAggregators;
import org.openjdk.jmc.flightrecorder.rules.IResult;
import org.openjdk.jmc.flightrecorder.rules.IResultValueProvider;
import org.openjdk.jmc.flightrecorder.rules.IRule;
import org.openjdk.jmc.flightrecorder.rules.ResultBuilder;
import org.openjdk.jmc.flightrecorder.rules.Severity;
import org.openjdk.jmc.flightrecorder.rules.TypedResult;
import org.openjdk.jmc.flightrecorder.rules.jdk.messages.internal.Messages;
import org.openjdk.jmc.flightrecorder.rules.util.RulesToolkit;

public class DiscouragedVmOptionsRule
implements IRule {
    private static final String DISCOURAGED_VM_OPTIONS_RESULT_ID = "DiscouragedVmOptions";
    private static final Map<String, RulesToolkit.EventAvailability> REQUIRED_EVENTS = RulesToolkit.RequiredEventsBuilder.create().addEventType("jdk.BooleanFlag", RulesToolkit.EventAvailability.AVAILABLE).build();

    private IResult getResult(IItemCollection items, IPreferenceValueProvider valueProvider, IResultValueProvider resultProvider) {
        Boolean unlockExperimentalVMOptions = (Boolean)items.getAggregate(JdkAggregators.UNLOCK_EXPERIMENTAL_VM_OPTIONS);
        Boolean ignoreUnrecognizedVMOptions = (Boolean)items.getAggregate(JdkAggregators.IGNORE_UNRECOGNIZED_VM_OPTIONS);
        if (unlockExperimentalVMOptions != null && ignoreUnrecognizedVMOptions != null && unlockExperimentalVMOptions.booleanValue() && ignoreUnrecognizedVMOptions.booleanValue()) {
            String longMessage = Messages.getString("UnlockExperimentalVMOptionsRuleFactory_TEXT_INFO_LONG") + " " + Messages.getString("IgnoreUnrecognizedVMOptionsRuleFactory_TEXT_INFO_LONG");
            return ResultBuilder.createFor((IRule)this, (IPreferenceValueProvider)valueProvider).setSeverity(Severity.INFO).setSummary(Messages.getString("DiscouragedVmOptionsRule_BOTH_EXPERIMENTAL_AND_IGNORE")).setExplanation(longMessage).build();
        }
        if (ignoreUnrecognizedVMOptions != null && ignoreUnrecognizedVMOptions.booleanValue()) {
            return ResultBuilder.createFor((IRule)this, (IPreferenceValueProvider)valueProvider).setSeverity(Severity.INFO).setSummary(Messages.getString("IgnoreUnrecognizedVMOptionsRuleFactory_TEXT_INFO")).setExplanation(Messages.getString("IgnoreUnrecognizedVMOptionsRuleFactory_TEXT_INFO_LONG")).build();
        }
        if (unlockExperimentalVMOptions != null && unlockExperimentalVMOptions.booleanValue()) {
            return ResultBuilder.createFor((IRule)this, (IPreferenceValueProvider)valueProvider).setSeverity(Severity.INFO).setSummary(Messages.getString("UnlockExperimentalVMOptionsRuleFactory_TEXT_INFO")).setExplanation(Messages.getString("UnlockExperimentalVMOptionsRuleFactory_TEXT_INFO_LONG")).build();
        }
        return ResultBuilder.createFor((IRule)this, (IPreferenceValueProvider)valueProvider).setSeverity(Severity.OK).setSummary(Messages.getString("DiscouragedVmOptionsRule_TEXT_OK")).build();
    }

    public RunnableFuture<IResult> createEvaluation(final IItemCollection items, final IPreferenceValueProvider valueProvider, final IResultValueProvider resultValueProvider) {
        FutureTask<IResult> evaluationTask = new FutureTask<IResult>(new Callable<IResult>(){

            @Override
            public IResult call() throws Exception {
                return DiscouragedVmOptionsRule.this.getResult(items, valueProvider, resultValueProvider);
            }
        });
        return evaluationTask;
    }

    public Collection<TypedPreference<?>> getConfigurationAttributes() {
        return Collections.emptyList();
    }

    public String getId() {
        return DISCOURAGED_VM_OPTIONS_RESULT_ID;
    }

    public String getName() {
        return Messages.getString("DiscouragedVmOptionsRule_RULE_NAME");
    }

    public String getTopic() {
        return "jvm_information";
    }

    public Map<String, RulesToolkit.EventAvailability> getRequiredEvents() {
        return REQUIRED_EVENTS;
    }

    public Collection<TypedResult<?>> getResults() {
        return Collections.emptyList();
    }
}

