/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jmc.flightrecorder.rules.jdk.memory;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.FutureTask;
import java.util.concurrent.RunnableFuture;
import org.openjdk.jmc.common.item.Aggregators;
import org.openjdk.jmc.common.item.IAccessorFactory;
import org.openjdk.jmc.common.item.IItem;
import org.openjdk.jmc.common.item.IItemCollection;
import org.openjdk.jmc.common.item.IItemIterable;
import org.openjdk.jmc.common.unit.ContentType;
import org.openjdk.jmc.common.unit.IQuantity;
import org.openjdk.jmc.common.unit.IUnit;
import org.openjdk.jmc.common.unit.UnitLookup;
import org.openjdk.jmc.common.util.IPreferenceValueProvider;
import org.openjdk.jmc.common.util.TypedPreference;
import org.openjdk.jmc.flightrecorder.jdk.JdkAggregators;
import org.openjdk.jmc.flightrecorder.jdk.JdkAttributes;
import org.openjdk.jmc.flightrecorder.jdk.JdkFilters;
import org.openjdk.jmc.flightrecorder.rules.IResult;
import org.openjdk.jmc.flightrecorder.rules.IResultValueProvider;
import org.openjdk.jmc.flightrecorder.rules.IRule;
import org.openjdk.jmc.flightrecorder.rules.ResultBuilder;
import org.openjdk.jmc.flightrecorder.rules.Severity;
import org.openjdk.jmc.flightrecorder.rules.TypedResult;
import org.openjdk.jmc.flightrecorder.rules.jdk.memory.CollectorType;
import org.openjdk.jmc.flightrecorder.rules.jdk.messages.internal.Messages;
import org.openjdk.jmc.flightrecorder.rules.util.RulesToolkit;

public class GcInvertedParallelismRule
implements IRule {
    private static final String INVERTED_PARALLELISM_RESULT_ID = "GcInvertedParallelism";
    private static final Map<String, RulesToolkit.EventAvailability> REQUIRED_EVENTS = RulesToolkit.RequiredEventsBuilder.create().addEventType("jdk.GCConfiguration", RulesToolkit.EventAvailability.AVAILABLE).addEventType("jdk.GCCPUTime", RulesToolkit.EventAvailability.AVAILABLE).build();
    public static final TypedResult<IQuantity> GC_CPU_TIME_EVENT_COUNT = new TypedResult("gcCpuTimeEventCount", "GCCPUTime Event Count", "The number of recorded jdk.GCCPUTime events.", (ContentType)UnitLookup.NUMBER, IQuantity.class);
    public static final TypedResult<Long> INVERTED_PARALLELISM_COUNT = new TypedResult("invertedParallelismCount", "Inverted Parallelism Count", "The number of detected instances of Inverted Parallelism.", UnitLookup.RAW_LONG, Long.class);
    private static final Collection<TypedResult<?>> RESULT_ATTRIBUTES = Arrays.asList(GC_CPU_TIME_EVENT_COUNT, INVERTED_PARALLELISM_COUNT);

    public RunnableFuture<IResult> createEvaluation(final IItemCollection items, final IPreferenceValueProvider valueProvider, IResultValueProvider resultProvider) {
        return new FutureTask<IResult>(new Callable<IResult>(){

            @Override
            public IResult call() throws Exception {
                if (((String)items.getAggregate(JdkAggregators.OLD_COLLECTOR)).equals(CollectorType.SERIAL_OLD.getCollectorName())) {
                    return ResultBuilder.createFor((IRule)GcInvertedParallelismRule.this, (IPreferenceValueProvider)valueProvider).setSeverity(Severity.IGNORE).build();
                }
                IItemCollection gcCpuTimeItems = items.apply(JdkFilters.GC_CPU_TIME);
                long invertedParallelismCount = 0L;
                for (IItemIterable item : gcCpuTimeItems) {
                    for (IItem event : item) {
                        long timeReal;
                        long timeSystem;
                        long timeUser = ((IQuantity)RulesToolkit.getValue((IItem)event, (IAccessorFactory)JdkAttributes.GC_TIME_USER)).longValueIn((IUnit)UnitLookup.NANOSECOND);
                        if (!GcInvertedParallelismRule.isInvertedParallelism(GcInvertedParallelismRule.calcParallelism(timeUser, timeSystem = ((IQuantity)RulesToolkit.getValue((IItem)event, (IAccessorFactory)JdkAttributes.GC_TIME_SYSTEM)).longValueIn((IUnit)UnitLookup.NANOSECOND), timeReal = ((IQuantity)RulesToolkit.getValue((IItem)event, (IAccessorFactory)JdkAttributes.GC_TIME_REAL)).longValueIn((IUnit)UnitLookup.NANOSECOND)))) continue;
                        ++invertedParallelismCount;
                    }
                }
                if (invertedParallelismCount == 0L) {
                    return ResultBuilder.createFor((IRule)GcInvertedParallelismRule.this, (IPreferenceValueProvider)valueProvider).setSeverity(Severity.OK).setSummary("OK").build();
                }
                return ResultBuilder.createFor((IRule)GcInvertedParallelismRule.this, (IPreferenceValueProvider)valueProvider).addResult(INVERTED_PARALLELISM_COUNT, (Object)invertedParallelismCount).addResult(GC_CPU_TIME_EVENT_COUNT, (Object)((IQuantity)gcCpuTimeItems.getAggregate(Aggregators.count()))).setSeverity(Severity.WARNING).setSummary(Messages.getString("GcInvertedParallelism_TEXT_WARN_SHORT")).setExplanation(Messages.getString("GcInvertedParallelism_TEXT_WARN_LONG")).build();
            }
        });
    }

    public static int calcParallelism(long timeUser, long timeSys, long timeReal) {
        if (timeReal == 0L) {
            if (timeUser == 0L && timeUser == 0L) {
                return 100;
            }
            return Integer.MAX_VALUE;
        }
        BigDecimal parallelism = new BigDecimal(timeUser);
        parallelism = parallelism.add(new BigDecimal(timeSys));
        BigDecimal hundred = new BigDecimal("100");
        parallelism = parallelism.multiply(hundred);
        parallelism = parallelism.divide(new BigDecimal(timeReal), 0, RoundingMode.CEILING);
        return parallelism.intValue();
    }

    public static boolean isInvertedParallelism(int parallelism) {
        return parallelism < 100;
    }

    public Collection<TypedPreference<?>> getConfigurationAttributes() {
        return Collections.emptyList();
    }

    public String getId() {
        return INVERTED_PARALLELISM_RESULT_ID;
    }

    public String getName() {
        return Messages.getString("GcInvertedParallelism_RULE_NAME");
    }

    public String getTopic() {
        return "garbage_collection";
    }

    public Map<String, RulesToolkit.EventAvailability> getRequiredEvents() {
        return REQUIRED_EVENTS;
    }

    public Collection<TypedResult<?>> getResults() {
        return RESULT_ATTRIBUTES;
    }
}

