/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jmc.flightrecorder.rules.jdk.memory;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.FutureTask;
import java.util.concurrent.RunnableFuture;
import org.openjdk.jmc.common.item.Aggregators;
import org.openjdk.jmc.common.item.IAttribute;
import org.openjdk.jmc.common.item.ICanonicalAccessorFactory;
import org.openjdk.jmc.common.item.IItemCollection;
import org.openjdk.jmc.common.item.IItemFilter;
import org.openjdk.jmc.common.item.ItemFilters;
import org.openjdk.jmc.common.item.PersistableItemFilter;
import org.openjdk.jmc.common.unit.ContentType;
import org.openjdk.jmc.common.unit.IQuantity;
import org.openjdk.jmc.common.unit.UnitLookup;
import org.openjdk.jmc.common.util.IPreferenceValueProvider;
import org.openjdk.jmc.common.util.TypedPreference;
import org.openjdk.jmc.flightrecorder.jdk.JdkAttributes;
import org.openjdk.jmc.flightrecorder.jdk.JdkFilters;
import org.openjdk.jmc.flightrecorder.rules.IResult;
import org.openjdk.jmc.flightrecorder.rules.IResultValueProvider;
import org.openjdk.jmc.flightrecorder.rules.IRule;
import org.openjdk.jmc.flightrecorder.rules.ResultBuilder;
import org.openjdk.jmc.flightrecorder.rules.Severity;
import org.openjdk.jmc.flightrecorder.rules.TypedResult;
import org.openjdk.jmc.flightrecorder.rules.jdk.messages.internal.Messages;
import org.openjdk.jmc.flightrecorder.rules.util.RulesToolkit;

public class GcPauseTargetRule
implements IRule {
    private static final String GC_PAUSE_TARGET_RESULT_ID = "GcPauseTargetRule";
    private static final Map<String, RulesToolkit.EventAvailability> REQUIRED_EVENTS = RulesToolkit.RequiredEventsBuilder.create().addEventType("jdk.G1MMU", RulesToolkit.EventAvailability.AVAILABLE).build();
    public static final TypedResult<IQuantity> EXCEEDED_PERCENT = new TypedResult("gcExceededPercent", "Pause target exceeded percent", "The percentage of G1MMU events where the gcTime exceeded the pauseTarget.", (ContentType)UnitLookup.PERCENTAGE, IQuantity.class);
    public static final TypedResult<IQuantity> G1MMU_TOTAL = new TypedResult("g1mmuTotal", "Total G1MMU Events", "The number of G1MMU events that occured during the recording.", (ContentType)UnitLookup.NUMBER, IQuantity.class);
    public static final TypedResult<IQuantity> G1MMU_EXCEEDED = new TypedResult("g1mmuExceeded", "Exceeded pause targets", "The number of G1MMU events where the gcTime exceeded the pauseTarget.", (ContentType)UnitLookup.NUMBER, IQuantity.class);
    public static final TypedResult<IQuantity> PAUSE_TARGET = new TypedResult("pauseTarget", "Pause target", "Max time allowed to be spent on GC during last time slice.", (ContentType)UnitLookup.NUMBER, IQuantity.class);
    public final Collection<TypedResult<?>> RESULT_ATTRIBUTES = Arrays.asList(EXCEEDED_PERCENT, G1MMU_TOTAL, G1MMU_EXCEEDED, PAUSE_TARGET);

    public RunnableFuture<IResult> createEvaluation(final IItemCollection items, final IPreferenceValueProvider preferenceValueProvider, IResultValueProvider dependencyResults) {
        FutureTask<IResult> evaluationTask = new FutureTask<IResult>(new Callable<IResult>(){

            @Override
            public IResult call() throws Exception {
                IQuantity pauseTarget = (IQuantity)items.getAggregate(Aggregators.max((IAttribute)JdkAttributes.GC_PAUSE_TARGET));
                IQuantity maxGcTime = (IQuantity)items.getAggregate(Aggregators.max((IAttribute)JdkAttributes.GC_TIME));
                if (maxGcTime.compareTo((Object)pauseTarget) < 1) {
                    return ResultBuilder.createFor((IRule)GcPauseTargetRule.this, (IPreferenceValueProvider)preferenceValueProvider).setSeverity(Severity.OK).setSummary(Messages.getString("GcPauseTargetRule_TEXT_OK")).addResult(PAUSE_TARGET, (Object)pauseTarget).build();
                }
                IItemCollection g1mmuItems = items.apply(JdkFilters.GC_G1MMU);
                IItemFilter filter = ItemFilters.buildComparisonFilter((PersistableItemFilter.Kind)PersistableItemFilter.Kind.MORE, (ICanonicalAccessorFactory)JdkAttributes.GC_TIME, (Comparable)pauseTarget);
                IQuantity g1mmuTotal = (IQuantity)g1mmuItems.getAggregate(Aggregators.count());
                IQuantity g1mmuExceeded = (IQuantity)g1mmuItems.apply(filter).getAggregate(Aggregators.count());
                IQuantity exceededPercent = RulesToolkit.toRatioPercent((IQuantity)g1mmuExceeded, (IQuantity)g1mmuTotal);
                return ResultBuilder.createFor((IRule)GcPauseTargetRule.this, (IPreferenceValueProvider)preferenceValueProvider).setSeverity(Severity.WARNING).setSummary(Messages.getString("GcPauseTargetRule_TEXT_WARN_SHORT")).setExplanation(Messages.getString("GcPauseTargetRule_TEXT_WARN_LONG")).addResult(PAUSE_TARGET, (Object)pauseTarget).addResult(EXCEEDED_PERCENT, (Object)exceededPercent).addResult(G1MMU_TOTAL, (Object)g1mmuTotal).addResult(G1MMU_EXCEEDED, (Object)g1mmuExceeded).build();
            }
        });
        return evaluationTask;
    }

    public Collection<TypedPreference<?>> getConfigurationAttributes() {
        return Collections.emptyList();
    }

    public String getId() {
        return GC_PAUSE_TARGET_RESULT_ID;
    }

    public String getName() {
        return Messages.getString("GcPauseTargetRule_RULE_NAME");
    }

    public String getTopic() {
        return "garbage_collection";
    }

    public Map<String, RulesToolkit.EventAvailability> getRequiredEvents() {
        return REQUIRED_EVENTS;
    }

    public Collection<TypedResult<?>> getResults() {
        return this.RESULT_ATTRIBUTES;
    }
}

