/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jmc.flightrecorder.rules.jdk.memory;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.FutureTask;
import java.util.concurrent.RunnableFuture;
import org.openjdk.jmc.common.item.IItemCollection;
import org.openjdk.jmc.common.unit.ContentType;
import org.openjdk.jmc.common.unit.IPersister;
import org.openjdk.jmc.common.unit.IQuantity;
import org.openjdk.jmc.common.unit.UnitLookup;
import org.openjdk.jmc.common.util.IPreferenceValueProvider;
import org.openjdk.jmc.common.util.TypedPreference;
import org.openjdk.jmc.flightrecorder.rules.DependsOn;
import org.openjdk.jmc.flightrecorder.rules.IResult;
import org.openjdk.jmc.flightrecorder.rules.IResultValueProvider;
import org.openjdk.jmc.flightrecorder.rules.IRule;
import org.openjdk.jmc.flightrecorder.rules.ResultBuilder;
import org.openjdk.jmc.flightrecorder.rules.Severity;
import org.openjdk.jmc.flightrecorder.rules.TypedResult;
import org.openjdk.jmc.flightrecorder.rules.jdk.memory.GarbageCollectionInfoRule;
import org.openjdk.jmc.flightrecorder.rules.jdk.memory.GarbageCollectionsInfo;
import org.openjdk.jmc.flightrecorder.rules.jdk.messages.internal.Messages;
import org.openjdk.jmc.flightrecorder.rules.util.RulesToolkit;

@DependsOn(value=GarbageCollectionInfoRule.class)
public class HeapInspectionRule
implements IRule {
    private static final String HEAP_INSPECTION_RESULT_ID = "HeapInspectionGc";
    public static final TypedPreference<IQuantity> HEAP_INSPECTION_LIMIT = new TypedPreference("heap.inspection.info.limit", Messages.getString("HeapInspectionRule_CONFIG_WARNING_LIMIT"), Messages.getString("HeapInspectionRule_CONFIG_WARNING_LIMIT_LONG"), (IPersister)UnitLookup.NUMBER, (Object)UnitLookup.NUMBER_UNITY.quantity(1L));
    private static final List<TypedPreference<?>> CONFIG_ATTRIBUTES = Arrays.asList(HEAP_INSPECTION_LIMIT);
    public static final TypedResult<IQuantity> OBJECT_COUNT_GCS = new TypedResult("objectCountGCs", "Object Count GCs", "The number of heap inspection GCs.", (ContentType)UnitLookup.NUMBER, IQuantity.class);
    private static final Collection<TypedResult<?>> RESULT_ATTRIBUTES = Arrays.asList(TypedResult.SCORE, OBJECT_COUNT_GCS);
    private static final Map<String, RulesToolkit.EventAvailability> REQUIRED_EVENTS = RulesToolkit.RequiredEventsBuilder.create().addEventType("jdk.GarbageCollection", RulesToolkit.EventAvailability.AVAILABLE).build();

    public RunnableFuture<IResult> createEvaluation(final IItemCollection items, final IPreferenceValueProvider valueProvider, final IResultValueProvider resultProvider) {
        FutureTask<IResult> evaluationTask = new FutureTask<IResult>(new Callable<IResult>(){

            @Override
            public IResult call() throws Exception {
                return HeapInspectionRule.this.getHeapInspectionResult(items, valueProvider, resultProvider);
            }
        });
        return evaluationTask;
    }

    private IResult getHeapInspectionResult(IItemCollection items, IPreferenceValueProvider vp, IResultValueProvider rp) {
        IQuantity limit = (IQuantity)vp.getPreferenceValue(HEAP_INSPECTION_LIMIT);
        GarbageCollectionsInfo aggregate = (GarbageCollectionsInfo)rp.getResultValue(GarbageCollectionInfoRule.GC_INFO);
        if (aggregate.getObjectCountGCs() > 0) {
            double score = RulesToolkit.mapExp74((double)aggregate.getObjectCountGCs(), (double)limit.longValue());
            Object longMessage = Messages.getString("HeapInspectionGcRuleFactory_TEXT_INFO_LONG");
            if (RulesToolkit.isEventsEnabled((IItemCollection)items, (String[])new String[]{"jdk.ObjectCount"})) {
                longMessage = (String)longMessage + "\n" + Messages.getString("HeapInspectionGcRuleFactory_TEXT_INFO_LONG_JFR");
            }
            return ResultBuilder.createFor((IRule)this, (IPreferenceValueProvider)vp).setSeverity(Severity.get((double)score)).setSummary(Messages.getString("HeapInspectionGcRuleFactory_TEXT_INFO")).setExplanation((String)longMessage).addResult(TypedResult.SCORE, (Object)UnitLookup.NUMBER_UNITY.quantity(score)).addResult(OBJECT_COUNT_GCS, (Object)UnitLookup.NUMBER_UNITY.quantity((long)aggregate.getObjectCountGCs())).build();
        }
        return ResultBuilder.createFor((IRule)this, (IPreferenceValueProvider)vp).setSeverity(Severity.OK).setSummary(Messages.getString("HeapInspectionGcRuleFactory_TEXT_OK")).setExplanation(Messages.getString("HeapInspectionGcRuleFactory_TEXT_OK_LONG")).build();
    }

    public Collection<TypedPreference<?>> getConfigurationAttributes() {
        return CONFIG_ATTRIBUTES;
    }

    public String getId() {
        return HEAP_INSPECTION_RESULT_ID;
    }

    public String getName() {
        return Messages.getString("HeapInspectionGcRuleFactory_RULE_NAME");
    }

    public String getTopic() {
        return "garbage_collection";
    }

    public Map<String, RulesToolkit.EventAvailability> getRequiredEvents() {
        return REQUIRED_EVENTS;
    }

    public Collection<TypedResult<?>> getResults() {
        return RESULT_ATTRIBUTES;
    }
}

