/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jmc.greychart;

import java.awt.Color;
import java.awt.Font;
import java.awt.GraphicsEnvironment;
import java.util.Locale;
import java.util.logging.Level;
import javax.swing.UIManager;
import javax.swing.text.StyleContext;
import org.openjdk.jmc.common.util.Environment;
import org.openjdk.jmc.greychart.GreyChartPanel;

public final class FontAndColors {
    private static Color bgcolor = FontAndColors.createDefaultBackgroundColor();
    private static Color fgcolor = FontAndColors.createDefaultForegroundColor();
    private static Color middlecolor = FontAndColors.createDefaultMiddleColor();
    private static Font defaultFont = FontAndColors.createDefaultFont();

    private static Font createDefaultFont() {
        String fontName;
        int fontSize;
        try {
            Font currFont = UIManager.getFont("OptionPane.font");
            fontSize = currFont.getSize() * 5 / 6;
            fontName = currFont.getName();
        }
        catch (Exception e) {
            fontName = "SansSerif";
            fontSize = 12;
            GreyChartPanel.LOGGER.log(Level.WARNING, "Could not find option pane font, will proceed with default.", e);
        }
        return FontAndColors.extendFontForUsedLocale(StyleContext.getDefaultStyleContext().getFont(fontName, 0, fontSize));
    }

    private static Font extendFontForUsedLocale(Font font) {
        Locale used = Locale.getDefault();
        if (used.getLanguage().equals(Locale.JAPANESE.getLanguage())) {
            return FontAndColors.extendFontForLocale(font, "\u30e1\u30e2\u30ea\u30fc");
        }
        if (used.equals(Locale.SIMPLIFIED_CHINESE)) {
            return FontAndColors.extendFontForLocale(font, "\u5185\u5b58");
        }
        return font;
    }

    private static Font extendFontForLocale(Font font, String string) {
        if (font.canDisplayUpTo(string) == -1) {
            return font;
        }
        Font[] fontArray = GraphicsEnvironment.getLocalGraphicsEnvironment().getAllFonts();
        int n = fontArray.length;
        int n2 = 0;
        while (n2 < n) {
            Font f = fontArray[n2];
            if (f.canDisplayUpTo(string) == -1) {
                return f.deriveFont(font.getStyle(), font.getSize());
            }
            ++n2;
        }
        return font;
    }

    private static Color createDefaultForegroundColor() {
        Color fgcolor;
        try {
            fgcolor = UIManager.getColor("windowText");
        }
        catch (Exception e) {
            fgcolor = Color.BLACK;
            GreyChartPanel.LOGGER.log(Level.WARNING, "Could not find windowText color, will proceed with default.", e);
        }
        return fgcolor;
    }

    private static Color createDefaultBackgroundColor() {
        Color bgcolor;
        try {
            if (FontAndColors.isMac() || FontAndColors.isLinux()) {
                bgcolor = Color.WHITE;
                GreyChartPanel.LOGGER.log(Level.INFO, "Is running on Mac/Linux - explicitly setting background to White in GreyChart");
            } else {
                bgcolor = UIManager.getColor("window");
            }
        }
        catch (Exception e) {
            bgcolor = Color.WHITE;
            GreyChartPanel.LOGGER.log(Level.WARNING, "Could not find window color, will proceed with default.", e);
        }
        return bgcolor;
    }

    private static boolean isMac() {
        return Environment.getOSType() == Environment.OSType.MAC;
    }

    private static boolean isLinux() {
        return Environment.getOSType() == Environment.OSType.LINUX;
    }

    private static Color createDefaultMiddleColor() {
        int red = (fgcolor.getRed() + bgcolor.getRed()) / 2;
        int green = (fgcolor.getGreen() + bgcolor.getGreen()) / 2;
        int blue = (fgcolor.getBlue() + bgcolor.getBlue()) / 2;
        return new Color(red, green, blue);
    }

    public static Color getDefaultBackground() {
        return bgcolor;
    }

    public static Color getDefaultForeground() {
        return fgcolor;
    }

    public static Color getDefaultMiddleColor() {
        return middlecolor;
    }

    public static Font getDefaultFont() {
        return defaultFont;
    }
}

