/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jmc.greychart.impl;

import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import org.openjdk.jmc.greychart.AbstractGreyChart;
import org.openjdk.jmc.greychart.IndexRenderer;
import org.openjdk.jmc.greychart.SeriesPlotRenderer;
import org.openjdk.jmc.greychart.TitleRenderer;
import org.openjdk.jmc.greychart.data.DataSeriesProvider;
import org.openjdk.jmc.greychart.impl.DefaultHorizontalIndexRenderer;
import org.openjdk.jmc.greychart.impl.DefaultPieRenderer;
import org.openjdk.jmc.greychart.impl.DefaultTitleRenderer;
import org.openjdk.jmc.greychart.util.Messages;

public class DefaultPieGreyChart<T>
extends AbstractGreyChart<T> {
    private final Rectangle m_titleArea = new Rectangle();
    private final Rectangle m_plotArea = new Rectangle();
    private final Rectangle m_indexArea = new Rectangle();
    private TitleRenderer m_titleRenderer = new DefaultTitleRenderer(this);
    private IndexRenderer m_indexRenderer;

    public DefaultPieGreyChart() {
        super(Messages.getString("DefaultPieGreyChart_DEFAULT_TITLE"));
        this.setPlotRenderer(new DefaultPieRenderer(this));
        this.m_indexRenderer = new DefaultHorizontalIndexRenderer(this);
        this.setAntialiasingEnabled(true);
    }

    public DefaultPieGreyChart(DataSeriesProvider<T> provider) {
        this();
        this.setDataProvider(provider);
    }

    @Override
    public void render(Graphics2D ctx, Rectangle where) {
        ctx.setColor(this.getBackground());
        ctx.fillRect(where.x, where.y, where.width, where.height);
        this.m_titleArea.height = this.getTitleRenderer() == null ? 0 : this.getTitleRenderer().getPreferredDimensions((Graphics2D)ctx, (Rectangle)where).height;
        this.m_titleArea.width = where.width;
        this.m_titleRenderer.render(ctx, this.m_titleArea, where);
        this.m_indexArea.height = this.getIndexRenderer() == null ? 0 : this.getIndexRenderer().getPreferredDimensions((Graphics2D)ctx, (Rectangle)where).height;
        this.m_indexArea.width = where.width;
        this.m_plotArea.width = where.width;
        this.m_plotArea.height = where.height - this.m_titleArea.height - this.m_indexArea.height;
        this.m_plotArea.y = this.m_titleArea.height;
        this.m_indexArea.y = this.m_plotArea.y + this.m_plotArea.height;
        if (this.isAntaliasingEnabled()) {
            ctx.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        } else {
            ctx.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
        }
        if (this.m_titleArea.height > 0) {
            this.getTitleRenderer().render(ctx, this.m_titleArea, where);
        }
        if (this.m_indexArea.height > 0) {
            this.getIndexRenderer().render(ctx, this.m_indexArea, where);
        }
        this.getPlotRenderer().render(ctx, this.m_plotArea, where);
    }

    @Override
    public TitleRenderer getTitleRenderer() {
        return this.m_titleRenderer;
    }

    public void setTitleRenderer(TitleRenderer titleRenderer) {
        this.m_titleRenderer = titleRenderer;
    }

    @Override
    public IndexRenderer getIndexRenderer() {
        return this.m_indexRenderer;
    }

    @Override
    public void setIndexRenderer(IndexRenderer indexRenderer) {
        this.m_indexRenderer = indexRenderer;
    }

    public SeriesPlotRenderer getSeriesPlotRenderer() {
        return null;
    }

    public void setSeriesPlotRenderer(SeriesPlotRenderer renderer) {
    }
}

