/*
 * Copyright (c) 2012, 2025, Oracle and/or its affiliates. All rights reserved.
 * ORACLE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */

/*
 * COPYRIGHT AND PERMISSION NOTICE
 *
 * Copyright (c) 1991-2022 Unicode, Inc. All rights reserved.
 * Distributed under the Terms of Use in https://www.unicode.org/copyright.html.
 *
 * Permission is hereby granted, free of charge, to any person obtaining
 * a copy of the Unicode data files and any associated documentation
 * (the "Data Files") or Unicode software and any associated documentation
 * (the "Software") to deal in the Data Files or Software
 * without restriction, including without limitation the rights to use,
 * copy, modify, merge, publish, distribute, and/or sell copies of
 * the Data Files or Software, and to permit persons to whom the Data Files
 * or Software are furnished to do so, provided that either
 * (a) this copyright and permission notice appear with all copies
 * of the Data Files or Software, or
 * (b) this copyright and permission notice appear in associated
 * Documentation.
 *
 * THE DATA FILES AND SOFTWARE ARE PROVIDED "AS IS", WITHOUT WARRANTY OF
 * ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
 * WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 * NONINFRINGEMENT OF THIRD PARTY RIGHTS.
 * IN NO EVENT SHALL THE COPYRIGHT HOLDER OR HOLDERS INCLUDED IN THIS
 * NOTICE BE LIABLE FOR ANY CLAIM, OR ANY SPECIAL INDIRECT OR CONSEQUENTIAL
 * DAMAGES, OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE,
 * DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER
 * TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
 * PERFORMANCE OF THE DATA FILES OR SOFTWARE.
 *
 * Except as contained in this notice, the name of a copyright holder
 * shall not be used in advertising or otherwise to promote the sale,
 * use or other dealings in these Data Files or Software without prior
 * written authorization of the copyright holder.
 */

package sun.text.resources.cldr.ext;

import java.util.ListResourceBundle;

public class FormatData_ff_Adlm extends ListResourceBundle {
    @Override
    protected final Object[][] getContents() {
        final String metaValue_generic_DateFormatItem_yyyyMMMd = "d MMM\u2e41 y G";
        final String metaValue_generic_DateFormatItem_yyyyMd = "d-M-y GGGGG";
        final String metaValue_generic_DateFormatItem_yyyyMMMEd = "E\u2e41 d MMM\u2e41 y G";
        final String metaValue_generic_DateFormatItem_Gy = "y G";
        final String metaValue_generic_DateFormatItem_yyyyMMM = "MMM y G";
        final String[] metaValue_MonthNames = new String[] {
            "\ud83a\udd05\ud83a\udd2d\ud83a\udd45\ud83a\udd24\ud83a\udd2e",
            "\ud83a\udd15\ud83a\udd2e\ud83a\udd24\ud83a\udd3c\ud83a\udd2e",
            "\ud83a\udd10\ud83a\udd26\ud83a\udd2e\ud83a\udd45\ud83a\udd34\ud83a\udd2e",
            "\ud83a\udd05\ud83a\udd2b\ud83a\udd45\ud83a\udd3c\ud83a\udd2e",
            "\ud83a\udd01\ud83a\udd35\ud83a\udd45\ud83a\udd36\ud83a\udd2e",
            "\ud83a\udd11\ud83a\udd2e\ud83a\udd2a\ud83a\udd27\ud83a\udd2e",
            "\ud83a\udd03\ud83a\udd2e\ud83a\udd2a\ud83a\udd27\ud83a\udd2e",
            "\ud83a\udd14\ud83a\udd35\ud83a\udd33\ud83a\udd2e",
            "\ud83a\udd05\ud83a\udd2d\ud83a\udd24\ud83a\udd3c\ud83a\udd2e",
            "\ud83a\udd12\ud83a\udd22\ud83a\udd2a\ud83a\udd33\ud83a\udd2e",
            "\ud83a\udd14\ud83a\udd2e\ud83a\udd24\ud83a\udd2e",
            "\ud83a\udd04\ud83a\udd2e\ud83a\udd31\ud83a\udd3c\ud83a\udd2e",
            "",
        };
        final String[] metaValue_MonthNarrows = new String[] {
            "\ud83a\udd05",
            "\ud83a\udd15",
            "\ud83a\udd04",
            "\ud83a\udd05",
            "\ud83a\udd01",
            "\ud83a\udd11",
            "\ud83a\udd03",
            "\ud83a\udd14",
            "\ud83a\udd05",
            "\ud83a\udd12",
            "\ud83a\udd14",
            "\ud83a\udd04",
            "",
        };
        final String[] metaValue_generic_DayNames = new String[] {
            "\ud83a\udd08\ud83a\udd2b\ud83a\udd2c\ud83a\udd26\ud83a\udd2d\ud83a\udd2a\ud83a\udd46\ud83a\udd2b",
            "\ud83a\udd00\ud83a\udd44\ud83a\udd29\ud83a\udd35\ud83a\udd32\ud83a\udd4b\ud83a\udd23\ud83a\udd2b",
            "\ud83a\udd03\ud83a\udd22\ud83a\udd31\ud83a\udd26\ud83a\udd22\ud83a\udd44\ud83a\udd2a\ud83a\udd2b",
            "\ud83a\udd10\ud83a\udd36\ud83a\udd2b\ud83a\udd27\ud83a\udd24\ud83a\udd22\ud83a\udd44\ud83a\udd2a\ud83a\udd2b",
            "\ud83a\udd10\ud83a\udd22\ud83a\udd44\ud83a\udd27\ud83a\udd22\ud83a\udd44\ud83a\udd32\ud83a\udd23\ud83a\udd2b",
            "\ud83a\udd03\ud83a\udd22\ud83a\udd31\ud83a\udd32\ud83a\udd23\ud83a\udd2b",
            "\ud83a\udd16\ud83a\udd2e\ud83a\udd2a\ud83a\udd26\ud83a\udd2d\ud83a\udd2a\ud83a\udd46\ud83a\udd2b",
        };
        final String[] metaValue_generic_DayAbbreviations = new String[] {
            "\ud83a\udd08\ud83a\udd2b\ud83a\udd2c",
            "\ud83a\udd00\ud83a\udd44\ud83a\udd29\ud83a\udd35",
            "\ud83a\udd03\ud83a\udd22\ud83a\udd26",
            "\ud83a\udd14\ud83a\udd2b\ud83a\udd27",
            "\ud83a\udd10\ud83a\udd22\ud83a\udd44\ud83a\udd27",
            "\ud83a\udd03\ud83a\udd22\ud83a\udd23",
            "\ud83a\udd16\ud83a\udd2e\ud83a\udd2a",
        };
        final String[] metaValue_generic_DayNarrows = new String[] {
            "\ud83a\udd08",
            "\ud83a\udd00\ud83a\udd44",
            "\ud83a\udd03",
            "\ud83a\udd14",
            "\ud83a\udd10",
            "\ud83a\udd03",
            "\ud83a\udd16",
        };
        final String[] metaValue_generic_QuarterNames = new String[] {
            "\ud83a\udd10\ud83a\udd51",
            "\ud83a\udd10\ud83a\udd52",
            "\ud83a\udd10\ud83a\udd53",
            "\ud83a\udd10\ud83a\udd54",
        };
        final String[] metaValue_QuarterNarrows = new String[] {
            "\ud83a\udd51",
            "\ud83a\udd52",
            "\ud83a\udd53",
            "\ud83a\udd54",
        };
        final String[] metaValue_generic_abbreviated_AmPmMarkers = new String[] {
            "\ud83a\udd00\ud83a\udd0e",
            "\ud83a\udd07\ud83a\udd0e",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
        };
        final String[] metaValue_generic_narrow_AmPmMarkers = new String[] {
            "\ud83a\udd22",
            "\ud83a\udd29",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
        };
        final String[] metaValue_java_time_long_Eras = new String[] {
            "\ud83a\udd00\ud83a\udd23\ud83a\udd2e \ud83a\udd00\ud83a\udd32\ud83a\udd46\ud83a\udd22\ud83a\udd26\ud83a\udd2d \ud83a\udd0b\ud83a\udd45\ud83a\udd27\ud83a\udd22\ud83a\udd44",
            "\ud83a\udd07\ud83a\udd22\ud83a\udd44\ud83a\udd31\ud83a\udd2e \ud83a\udd00\ud83a\udd32\ud83a\udd46\ud83a\udd22\ud83a\udd26\ud83a\udd2d \ud83a\udd0b\ud83a\udd45\ud83a\udd27\ud83a\udd22\ud83a\udd44",
        };
        final String[] metaValue_java_time_Eras = new String[] {
            "\ud83a\udd00\ud83a\udd00\ud83a\udd0b",
            "\ud83a\udd07\ud83a\udd00\ud83a\udd0b",
        };
        final String[] metaValue_generic_TimePatterns = new String[] {
            "HH:mm:ss zzzz",
            "HH:mm:ss z",
            "HH:mm:ss",
            "HH:mm",
        };
        final String[] metaValue_generic_DateTimePatterns = new String[] {
            "{1} {0}",
            "{1} {0}",
            "{1} {0}",
            "{1} {0}",
        };
        final String metaValue_generic_DateFormatItem_yMMMEd = "E\u2e41 d MMM\u2e41 y";
        final String metaValue_generic_DateFormatItem_yMEd = "E\u2e41 d-M-y";
        final String metaValue_generic_DateFormatItem_yMMMd = "d MMM\u2e41 y";
        final String metaValue_generic_DateFormatItem_yw = "\ud83a\udd34\ud83a\udd2e\ud83a\udd32\ud83a\udd3c\ud83a\udd2b\ud83a\udd2a\ud83a\udd2b w \ud83a\udd32\ud83a\udd23\ud83a\udd2b\ud83a\udd2a Y";
        final String metaValue_generic_DateFormatItem_yQQQ = "QQQ y";
        final String metaValue_generic_DateFormatItem_yMMM = "MMM y";
        final String metaValue_generic_DateFormatItem_Md = "d-M";
        final String metaValue_generic_DateFormatItem_Ed = "E d";
        final String metaValue_generic_DateFormatItem_MMMMd = "d MMMM";
        final String metaValue_generic_DateFormatItem_MEd = "E d-M";
        final String metaValue_generic_DateFormatItem_MMMEd = "E d MMM";
        final String metaValue_generic_DateFormatItem_yMd = "d-M-y";
        final String metaValue_generic_DateFormatItem_MMMd = "d MMM";
        final String metaValue_generic_DateFormatItem_yM = "M-y";
        final String metaValue_generic_DateFormatItem_yMMMM = "MMMM y";
        final String metaValue_generic_DateFormatItem_MMMMW = "\ud83a\udd34\ud83a\udd2e\ud83a\udd32\ud83a\udd3c\ud83a\udd2b\ud83a\udd2a\ud83a\udd2b W \ud83a\udd32\ud83a\udd23\ud83a\udd2b\ud83a\udd2a MMMM";
        final String metaValue_generic_DateFormatItem_yQQQQ = "QQQQ y";
        final String[] metaValue_java_time_buddhist_long_Eras = new String[] {
            "BC",
            "\ud83a\udd18\ud83a\udd2d\ud83a\udd2a\ud83a\udd22\ud83a\udd24 \ud83a\udd04\ud83a\udd35\ud83a\udd45\ud83a\udd23\ud83a\udd22\ud83a\udd32\ud83a\udd33\ud83a\udd2e\ud83a\udd31\ud83a\udd22\ud83a\udd24",
        };
        final String[] metaValue_java_time_buddhist_Eras = new String[] {
            "BC",
            "\ud83a\udd18\ud83a\udd04",
        };
        final String[] metaValue_java_time_generic_DatePatterns = new String[] {
            "EEEE d MMMM\u2e41 y G",
            "d MMMM\u2e41 y G",
            "d MMM\u2e41 y G",
            "d-M-y GGGGG",
        };
        final String[] metaValue_generic_DatePatterns = new String[] {
            "EEEE d MMMM\u2e41 y GGGG",
            "d MMMM\u2e41 y GGGG",
            "d MMM\u2e41 y GGGG",
            "d-M-y G",
        };
        final String[] metaValue_java_time_japanese_long_Eras = new String[] {
            "\ud83a\udd07\ud83a\udd22\ud83a\udd44\ud83a\udd31\ud83a\udd2e \ud83a\udd00\ud83a\udd32\ud83a\udd46\ud83a\udd22\ud83a\udd26\ud83a\udd2d \ud83a\udd0b\ud83a\udd45\ud83a\udd27\ud83a\udd22\ud83a\udd44",
            "\ud83a\udd03\ud83a\udd2b\ud83a\udd34\ud83a\udd36\ud83a\udd2d",
            "\ud83a\udd1a\ud83a\udd22\ud83a\udd34\ud83a\udd43\ud83a\udd2e\ud83a\udd45",
            "\ud83a\udd21\ud83a\udd2e\ud83a\udd45\ud83a\udd31\ud83a\udd22",
            "\ud83a\udd16\ud83a\udd2b\ud83a\udd34\ud83a\udd27\ud83a\udd2b\ud83a\udd34",
            "\ud83a\udd08\ud83a\udd2b\ud83a\udd34\ud83a\udd31\ud83a\udd22",
        };
        final String[] metaValue_java_time_japanese_Eras = new String[] {
            "\ud83a\udd07\ud83a\udd00\ud83a\udd0b",
            "\ud83a\udd03\ud83a\udd2b\ud83a\udd34\ud83a\udd36\ud83a\udd2d",
            "\ud83a\udd1a\ud83a\udd22\ud83a\udd34\ud83a\udd43\ud83a\udd2e\ud83a\udd45",
            "\ud83a\udd21\ud83a\udd2e\ud83a\udd45\ud83a\udd31\ud83a\udd22",
            "\ud83a\udd16\ud83a\udd2b\ud83a\udd34\ud83a\udd27\ud83a\udd2b\ud83a\udd34",
            "\ud83a\udd08\ud83a\udd2b\ud83a\udd34\ud83a\udd31\ud83a\udd22",
        };
        final String[] metaValue_java_time_japanese_narrow_Eras = new String[] {
            "\ud83a\udd07\ud83a\udd00\ud83a\udd0b",
            "\ud83a\udd03",
            "\ud83a\udd1a",
            "\ud83a\udd05",
            "\ud83a\udd16",
            "\ud83a\udd08",
        };
        final String[] metaValue_java_time_roc_long_Eras = new String[] {
            "\ud83a\udd00\ud83a\udd4b\ud83a\udd01\ud83a\udd15",
            "\ud83a\udd03\ud83a\udd2d\ud83a\udd32\ud83a\udd3a\ud83a\udd35\ud83a\udd2e",
        };
        final String[] metaValue_java_time_islamic_long_Eras = new String[] {
            "",
            "\ud83a\udd07\ud83a\udd0a",
        };
        final String metaValue_calendarname_gregorian = "\ud83a\udd19\ud83a\udd22\ud83a\udd24\ud83a\udd2f\ud83a\udd2d\ud83a\udd25\ud83a\udd2b\ud83a\udd2a\ud83a\udd2b \ud83a\udd18\ud83a\udd2b\ud83a\udd2a\ud83a\udd3a\ud83a\udd2e\ud83a\udd2a\ud83a\udd2d\ud83a\udd34\ud83a\udd22\ud83a\udd32\ud83a\udd33\ud83a\udd2e";
        final String[] metaValue_adlm_NumberPatterns = new String[] {
            "#,##0.###",
            "\u00a4\u00a0#,##0.00",
            "#,##0%",
            "",
        };
        final String[] metaValue_brah_NumberElements = new String[] {
            ".",
            ",",
            ";",
            "%",
            "0",
            "#",
            "-",
            "E",
            "\u2030",
            "\u221e",
            "NaN",
            "",
            "",
        };
        final String[] metaValue_ListPatterns_or = new String[] {
            "{0}\u2e41 {1}",
            "{0}\u2e41 {1}",
            "{0}\u2e41 \ud83a\udd25\ud83a\udd22\ud83a\udd44\ud83a\udd2f\ud83a\udd35\ud83a\udd32 {1}",
            "{0} \ud83a\udd25\ud83a\udd22\ud83a\udd44\ud83a\udd2f\ud83a\udd35\ud83a\udd32 {1}",
            "",
        };
        final Object[][] data = new Object[][] {
            { "generic.DayNames", metaValue_generic_DayNames },
            { "generic.DayAbbreviations", metaValue_generic_DayAbbreviations },
            { "generic.DayNarrows", metaValue_generic_DayNarrows },
            { "generic.QuarterNames", metaValue_generic_QuarterNames },
            { "generic.narrow.AmPmMarkers", metaValue_generic_narrow_AmPmMarkers },
            { "generic.abbreviated.AmPmMarkers", metaValue_generic_abbreviated_AmPmMarkers },
            { "generic.TimePatterns", metaValue_generic_TimePatterns },
            { "java.time.generic.DatePatterns", metaValue_java_time_generic_DatePatterns },
            { "generic.DatePatterns", metaValue_generic_DatePatterns },
            { "generic.DateTimePatterns", metaValue_generic_DateTimePatterns },
            { "generic.DateFormatItem.yyyyMMMM", "MMMM y G" },
            { "generic.DateFormatItem.yMMMEd", metaValue_generic_DateFormatItem_yMMMEd },
            { "generic.DateFormatItem.yyyyQQQQ", "QQQQ y G" },
            { "generic.DateFormatItem.yMEd", metaValue_generic_DateFormatItem_yMEd },
            { "generic.DateFormatItem.yyyyMMMd", metaValue_generic_DateFormatItem_yyyyMMMd },
            { "generic.DateFormatItem.Gy", metaValue_generic_DateFormatItem_Gy },
            { "generic.DateFormatItem.yyyyMMMEd", metaValue_generic_DateFormatItem_yyyyMMMEd },
            { "generic.DateFormatItem.GyMMMd", metaValue_generic_DateFormatItem_yyyyMMMd },
            { "generic.DateFormatItem.yMMMd", metaValue_generic_DateFormatItem_yMMMd },
            { "generic.DateFormatItem.yw", metaValue_generic_DateFormatItem_yw },
            { "generic.DateFormatItem.yQQQ", metaValue_generic_DateFormatItem_yQQQ },
            { "generic.DateFormatItem.yyyyMEd", "E\u2e41 d-M-y GGGGG" },
            { "generic.DateFormatItem.yyyyMd", metaValue_generic_DateFormatItem_yyyyMd },
            { "generic.DateFormatItem.yMMM", metaValue_generic_DateFormatItem_yMMM },
            { "generic.DateFormatItem.Md", metaValue_generic_DateFormatItem_Md },
            { "generic.DateFormatItem.Ed", metaValue_generic_DateFormatItem_Ed },
            { "generic.DateFormatItem.yyyyMMM", metaValue_generic_DateFormatItem_yyyyMMM },
            { "generic.DateFormatItem.MMMMd", metaValue_generic_DateFormatItem_MMMMd },
            { "generic.DateFormatItem.MEd", metaValue_generic_DateFormatItem_MEd },
            { "generic.DateFormatItem.MMMEd", metaValue_generic_DateFormatItem_MMMEd },
            { "generic.DateFormatItem.yyyyQQQ", "QQQ y G" },
            { "generic.DateFormatItem.GyMd", metaValue_generic_DateFormatItem_yyyyMd },
            { "generic.DateFormatItem.GyMMMEd", metaValue_generic_DateFormatItem_yyyyMMMEd },
            { "generic.DateFormatItem.yyyyM", "M-y GGGGG" },
            { "generic.DateFormatItem.yMd", metaValue_generic_DateFormatItem_yMd },
            { "generic.DateFormatItem.MMMd", metaValue_generic_DateFormatItem_MMMd },
            { "generic.DateFormatItem.yM", metaValue_generic_DateFormatItem_yM },
            { "generic.DateFormatItem.yMMMM", metaValue_generic_DateFormatItem_yMMMM },
            { "generic.DateFormatItem.MMMMW", metaValue_generic_DateFormatItem_MMMMW },
            { "generic.DateFormatItem.yQQQQ", metaValue_generic_DateFormatItem_yQQQQ },
            { "generic.DateFormatItem.yyyy", metaValue_generic_DateFormatItem_Gy },
            { "generic.DateFormatItem.y", metaValue_generic_DateFormatItem_Gy },
            { "generic.DateFormatItem.GyMMM", metaValue_generic_DateFormatItem_yyyyMMM },
            { "MonthNames", metaValue_MonthNames },
            { "standalone.MonthNames", metaValue_MonthNames },
            { "MonthAbbreviations", metaValue_MonthNames },
            { "standalone.MonthAbbreviations",
                new String[] {
                    "\ud83a\udd05\ud83a\udd2d\ud83a\udd45\ud83a\udd24",
                    "\ud83a\udd15\ud83a\udd2e\ud83a\udd24",
                    "\ud83a\udd10\ud83a\udd26\ud83a\udd2e\ud83a\udd45\ud83a\udd34",
                    "\ud83a\udd05\ud83a\udd2b\ud83a\udd45\ud83a\udd3c",
                    "\ud83a\udd01\ud83a\udd35\ud83a\udd45\ud83a\udd36",
                    "\ud83a\udd11\ud83a\udd2e\ud83a\udd2a",
                    "\ud83a\udd03\ud83a\udd2e\ud83a\udd2a",
                    "\ud83a\udd14\ud83a\udd35\ud83a\udd33",
                    "\ud83a\udd05\ud83a\udd2d\ud83a\udd24",
                    "\ud83a\udd12\ud83a\udd22\ud83a\udd2a",
                    "\ud83a\udd14\ud83a\udd2e\ud83a\udd24",
                    "\ud83a\udd04\ud83a\udd2e\ud83a\udd31",
                    "",
                }
            },
            { "MonthNarrows", metaValue_MonthNarrows },
            { "standalone.MonthNarrows", metaValue_MonthNarrows },
            { "DayNames", metaValue_generic_DayNames },
            { "standalone.DayNames", metaValue_generic_DayNames },
            { "DayAbbreviations", metaValue_generic_DayAbbreviations },
            { "standalone.DayAbbreviations", metaValue_generic_DayAbbreviations },
            { "DayNarrows", metaValue_generic_DayNarrows },
            { "standalone.DayNarrows", metaValue_generic_DayNarrows },
            { "QuarterNames", metaValue_generic_QuarterNames },
            { "standalone.QuarterNames",
                new String[] {
                    "\ud83a\udd10\ud83a\udd22\ud83a\udd34\ud83a\udd29\ud83a\udd2d\ud83a\udd45\ud83a\udd2a\ud83a\udd2b \ud83a\udd51\ud83a\udd2a\ud83a\udd2b",
                    "\ud83a\udd10\ud83a\udd22\ud83a\udd34\ud83a\udd29\ud83a\udd2d\ud83a\udd45\ud83a\udd2a\ud83a\udd2b \ud83a\udd52\ud83a\udd2a\ud83a\udd2b",
                    "\ud83a\udd10\ud83a\udd22\ud83a\udd34\ud83a\udd29\ud83a\udd2d\ud83a\udd45\ud83a\udd2a\ud83a\udd2b \ud83a\udd53\ud83a\udd2a\ud83a\udd2b",
                    "\ud83a\udd10\ud83a\udd22\ud83a\udd34\ud83a\udd29\ud83a\udd2d\ud83a\udd45\ud83a\udd2a\ud83a\udd2b \ud83a\udd54\ud83a\udd2a\ud83a\udd2b",
                }
            },
            { "QuarterAbbreviations", metaValue_generic_QuarterNames },
            { "QuarterNarrows", metaValue_QuarterNarrows },
            { "standalone.QuarterNarrows", metaValue_QuarterNarrows },
            { "AmPmMarkers", metaValue_generic_abbreviated_AmPmMarkers },
            { "narrow.AmPmMarkers", metaValue_generic_narrow_AmPmMarkers },
            { "abbreviated.AmPmMarkers", metaValue_generic_abbreviated_AmPmMarkers },
            { "java.time.long.Eras", metaValue_java_time_long_Eras },
            { "long.Eras", metaValue_java_time_long_Eras },
            { "java.time.Eras", metaValue_java_time_Eras },
            { "Eras", metaValue_java_time_Eras },
            { "java.time.narrow.Eras", metaValue_java_time_Eras },
            { "narrow.Eras", metaValue_java_time_Eras },
            { "field.era", "\ud83a\udd3a\ud83a\udd2d\ud83a\udd2a\ud83a\udd22\ud83a\udd24" },
            { "field.year", "\ud83a\udd38\ud83a\udd2d\ud83a\udd3c\ud83a\udd22\ud83a\udd44\ud83a\udd32\ud83a\udd23\ud83a\udd2b" },
            { "field.month", "\ud83a\udd24\ud83a\udd2b\ud83a\udd31\ud83a\udd2a\ud83a\udd35" },
            { "field.week", "\ud83a\udd34\ud83a\udd2e\ud83a\udd32\ud83a\udd3c\ud83a\udd2b\ud83a\udd2a\ud83a\udd2b" },
            { "field.weekday", "\ud83a\udd3b\ud83a\udd22\ud83a\udd24\ud83a\udd22\ud83a\udd44\ud83a\udd32\ud83a\udd23\ud83a\udd2b \ud83a\udd32\ud83a\udd23\ud83a\udd2b\ud83a\udd2a \ud83a\udd34\ud83a\udd2e\ud83a\udd32\ud83a\udd3c\ud83a\udd2b\ud83a\udd2a\ud83a\udd2b" },
            { "field.dayperiod", "\ud83a\udd00\ud83a\udd0e/\ud83a\udd07\ud83a\udd0e" },
            { "field.hour", "\ud83a\udd32\ud83a\udd36\ud83a\udd22\ud83a\udd25\ud83a\udd23\ud83a\udd2d" },
            { "timezone.gmtFormat", "\ud83a\udd11\ud83a\udd16\ud83a\udd18{0}" },
            { "timezone.gmtZeroFormat", "\ud83a\udd11\ud83a\udd16\ud83a\udd18" },
            { "timezone.regionFormat", "{0} \ud83a\udd11\ud83a\udd2d\ud83a\udd36\ud83a\udd2e\ud83a\udd45\ud83a\udd2a\ud83a\udd2b" },
            { "timezone.regionFormat.daylight", "{0} \ud83a\udd10\ud83a\udd36\ud83a\udd22\ud83a\udd25\ud83a\udd32\ud83a\udd23\ud83a\udd2d \ud83a\udd15\ud83a\udd2b\ud83a\udd45\ud83a\udd2f\ud83a\udd35" },
            { "timezone.regionFormat.standard", "{0} \ud83a\udd11\ud83a\udd2d\ud83a\udd36\ud83a\udd2e\ud83a\udd45\ud83a\udd2a\ud83a\udd2b \ud83a\udd16\ud83a\udd22\ud83a\udd31\ud83a\udd2a\ud83a\udd35\ud83a\udd32\ud83a\udd4b\ud83a\udd23\ud83a\udd2b" },
            { "field.minute", "\ud83a\udd38\ud83a\udd2e\ud83a\udd36\ud83a\udd2e\ud83a\udd25\ud83a\udd22\ud83a\udd44\ud83a\udd2a\ud83a\udd2b" },
            { "field.second", "\ud83a\udd33\ud83a\udd2d\ud83a\udd32\ud83a\udd30\ud83a\udd2b\ud83a\udd2a\ud83a\udd2b" },
            { "field.zone", "\ud83a\udd32\ud83a\udd36\ud83a\udd22\ud83a\udd25\ud83a\udd23\ud83a\udd2d \ud83a\udd32\ud83a\udd2e\ud83a\udd33\ud83a\udd46\ud83a\udd35\ud83a\udd45\ud83a\udd2a\ud83a\udd2b" },
            { "TimePatterns", metaValue_generic_TimePatterns },
            { "DatePatterns",
                new String[] {
                    "EEEE d MMMM\u2e41 y",
                    "d MMMM\u2e41 y",
                    "d MMM\u2e41 y",
                    "d-M-y",
                }
            },
            { "DateTimePatterns", metaValue_generic_DateTimePatterns },
            { "DateFormatItem.yMMMEd", metaValue_generic_DateFormatItem_yMMMEd },
            { "DateFormatItem.yMEd", metaValue_generic_DateFormatItem_yMEd },
            { "DateFormatItem.Gy", metaValue_generic_DateFormatItem_Gy },
            { "DateFormatItem.GyMMMd", metaValue_generic_DateFormatItem_yyyyMMMd },
            { "DateFormatItem.yMMMd", metaValue_generic_DateFormatItem_yMMMd },
            { "DateFormatItem.yw", metaValue_generic_DateFormatItem_yw },
            { "DateFormatItem.yQQQ", metaValue_generic_DateFormatItem_yQQQ },
            { "DateFormatItem.yMMM", metaValue_generic_DateFormatItem_yMMM },
            { "DateFormatItem.Md", metaValue_generic_DateFormatItem_Md },
            { "DateFormatItem.Ed", metaValue_generic_DateFormatItem_Ed },
            { "DateFormatItem.MMMMd", metaValue_generic_DateFormatItem_MMMMd },
            { "DateFormatItem.MEd", metaValue_generic_DateFormatItem_MEd },
            { "DateFormatItem.MMMEd", metaValue_generic_DateFormatItem_MMMEd },
            { "DateFormatItem.GyMd", metaValue_generic_DateFormatItem_yyyyMd },
            { "DateFormatItem.GyMMMEd", metaValue_generic_DateFormatItem_yyyyMMMEd },
            { "DateFormatItem.yMd", metaValue_generic_DateFormatItem_yMd },
            { "DateFormatItem.MMMd", metaValue_generic_DateFormatItem_MMMd },
            { "DateFormatItem.yM", metaValue_generic_DateFormatItem_yM },
            { "DateFormatItem.yMMMM", metaValue_generic_DateFormatItem_yMMMM },
            { "DateFormatItem.MMMMW", metaValue_generic_DateFormatItem_MMMMW },
            { "DateFormatItem.yQQQQ", metaValue_generic_DateFormatItem_yQQQQ },
            { "DateFormatItem.GyMMM", metaValue_generic_DateFormatItem_yyyyMMM },
            { "buddhist.MonthNames", metaValue_MonthNames },
            { "buddhist.DayNames", metaValue_generic_DayNames },
            { "buddhist.DayAbbreviations", metaValue_generic_DayAbbreviations },
            { "buddhist.QuarterNames", metaValue_generic_QuarterNames },
            { "buddhist.AmPmMarkers", metaValue_generic_abbreviated_AmPmMarkers },
            { "buddhist.narrow.AmPmMarkers", metaValue_generic_narrow_AmPmMarkers },
            { "buddhist.abbreviated.AmPmMarkers", metaValue_generic_abbreviated_AmPmMarkers },
            { "java.time.buddhist.long.Eras", metaValue_java_time_buddhist_long_Eras },
            { "buddhist.long.Eras", metaValue_java_time_buddhist_long_Eras },
            { "java.time.buddhist.Eras", metaValue_java_time_buddhist_Eras },
            { "buddhist.Eras", metaValue_java_time_buddhist_Eras },
            { "java.time.buddhist.narrow.Eras", metaValue_java_time_buddhist_Eras },
            { "buddhist.narrow.Eras", metaValue_java_time_buddhist_Eras },
            { "buddhist.TimePatterns", metaValue_generic_TimePatterns },
            { "java.time.buddhist.DatePatterns", metaValue_java_time_generic_DatePatterns },
            { "buddhist.DatePatterns", metaValue_generic_DatePatterns },
            { "buddhist.DateFormatItem.yMMMEd", metaValue_generic_DateFormatItem_yMMMEd },
            { "buddhist.DateFormatItem.yMEd", metaValue_generic_DateFormatItem_yMEd },
            { "buddhist.DateFormatItem.Gy", metaValue_generic_DateFormatItem_Gy },
            { "buddhist.DateFormatItem.GyMMMd", metaValue_generic_DateFormatItem_yyyyMMMd },
            { "buddhist.DateFormatItem.yMMMd", metaValue_generic_DateFormatItem_yMMMd },
            { "buddhist.DateFormatItem.yw", metaValue_generic_DateFormatItem_yw },
            { "buddhist.DateFormatItem.yQQQ", metaValue_generic_DateFormatItem_yQQQ },
            { "buddhist.DateFormatItem.yMMM", metaValue_generic_DateFormatItem_yMMM },
            { "buddhist.DateFormatItem.Md", metaValue_generic_DateFormatItem_Md },
            { "buddhist.DateFormatItem.Ed", metaValue_generic_DateFormatItem_Ed },
            { "buddhist.DateFormatItem.MMMMd", metaValue_generic_DateFormatItem_MMMMd },
            { "buddhist.DateFormatItem.MEd", metaValue_generic_DateFormatItem_MEd },
            { "buddhist.DateFormatItem.MMMEd", metaValue_generic_DateFormatItem_MMMEd },
            { "buddhist.DateFormatItem.GyMd", metaValue_generic_DateFormatItem_yyyyMd },
            { "buddhist.DateFormatItem.GyMMMEd", metaValue_generic_DateFormatItem_yyyyMMMEd },
            { "buddhist.DateFormatItem.yMd", metaValue_generic_DateFormatItem_yMd },
            { "buddhist.DateFormatItem.MMMd", metaValue_generic_DateFormatItem_MMMd },
            { "buddhist.DateFormatItem.yM", metaValue_generic_DateFormatItem_yM },
            { "buddhist.DateFormatItem.yMMMM", metaValue_generic_DateFormatItem_yMMMM },
            { "buddhist.DateFormatItem.MMMMW", metaValue_generic_DateFormatItem_MMMMW },
            { "buddhist.DateFormatItem.yQQQQ", metaValue_generic_DateFormatItem_yQQQQ },
            { "buddhist.DateFormatItem.GyMMM", metaValue_generic_DateFormatItem_yyyyMMM },
            { "japanese.MonthNames", metaValue_MonthNames },
            { "japanese.MonthAbbreviations", metaValue_MonthNames },
            { "japanese.DayNames", metaValue_generic_DayNames },
            { "japanese.DayAbbreviations", metaValue_generic_DayAbbreviations },
            { "japanese.QuarterNames", metaValue_generic_QuarterNames },
            { "japanese.QuarterNarrows", metaValue_QuarterNarrows },
            { "japanese.AmPmMarkers", metaValue_generic_abbreviated_AmPmMarkers },
            { "japanese.narrow.AmPmMarkers", metaValue_generic_narrow_AmPmMarkers },
            { "japanese.abbreviated.AmPmMarkers", metaValue_generic_abbreviated_AmPmMarkers },
            { "java.time.japanese.long.Eras", metaValue_java_time_japanese_long_Eras },
            { "japanese.long.Eras", metaValue_java_time_japanese_long_Eras },
            { "java.time.japanese.Eras", metaValue_java_time_japanese_Eras },
            { "japanese.Eras", metaValue_java_time_japanese_Eras },
            { "java.time.japanese.narrow.Eras", metaValue_java_time_japanese_narrow_Eras },
            { "japanese.narrow.Eras", metaValue_java_time_japanese_narrow_Eras },
            { "japanese.TimePatterns", metaValue_generic_TimePatterns },
            { "java.time.japanese.DatePatterns", metaValue_java_time_generic_DatePatterns },
            { "japanese.DatePatterns",
                new String[] {
                    "EEEE d MMMM\u2e41 yyyy GGGG",
                    "d MMMM\u2e41 yyyy GGGG",
                    "d MMM\u2e41 y GGGG",
                    "d-M-y G",
                }
            },
            { "japanese.DateTimePatterns",
                new String[] {
                    "{1} {0}",
                    "{1}\u2e41 {0}",
                    "{1}\u2e41 {0}",
                    "{1} {0}",
                }
            },
            { "japanese.DateFormatItem.yMMMEd", metaValue_generic_DateFormatItem_yMMMEd },
            { "japanese.DateFormatItem.yMEd", metaValue_generic_DateFormatItem_yMEd },
            { "japanese.DateFormatItem.Gy", metaValue_generic_DateFormatItem_Gy },
            { "japanese.DateFormatItem.GyMMMd", metaValue_generic_DateFormatItem_yyyyMMMd },
            { "japanese.DateFormatItem.yMMMd", metaValue_generic_DateFormatItem_yMMMd },
            { "japanese.DateFormatItem.yw", metaValue_generic_DateFormatItem_yw },
            { "japanese.DateFormatItem.yQQQ", metaValue_generic_DateFormatItem_yQQQ },
            { "japanese.DateFormatItem.yMMM", metaValue_generic_DateFormatItem_yMMM },
            { "japanese.DateFormatItem.Md", metaValue_generic_DateFormatItem_Md },
            { "japanese.DateFormatItem.Ed", metaValue_generic_DateFormatItem_Ed },
            { "japanese.DateFormatItem.MMMMd", metaValue_generic_DateFormatItem_MMMMd },
            { "japanese.DateFormatItem.MEd", metaValue_generic_DateFormatItem_MEd },
            { "japanese.DateFormatItem.MMMEd", metaValue_generic_DateFormatItem_MMMEd },
            { "japanese.DateFormatItem.GyMd", metaValue_generic_DateFormatItem_yyyyMd },
            { "japanese.DateFormatItem.GyMMMEd", metaValue_generic_DateFormatItem_yyyyMMMEd },
            { "japanese.DateFormatItem.yMd", metaValue_generic_DateFormatItem_yMd },
            { "japanese.DateFormatItem.MMMd", metaValue_generic_DateFormatItem_MMMd },
            { "japanese.DateFormatItem.yM", metaValue_generic_DateFormatItem_yM },
            { "japanese.DateFormatItem.yMMMM", metaValue_generic_DateFormatItem_yMMMM },
            { "japanese.DateFormatItem.MMMMW", metaValue_generic_DateFormatItem_MMMMW },
            { "japanese.DateFormatItem.yQQQQ", metaValue_generic_DateFormatItem_yQQQQ },
            { "japanese.DateFormatItem.GyMMM", metaValue_generic_DateFormatItem_yyyyMMM },
            { "roc.MonthNames", metaValue_MonthNames },
            { "roc.MonthAbbreviations", metaValue_MonthNames },
            { "roc.DayNames", metaValue_generic_DayNames },
            { "roc.DayAbbreviations", metaValue_generic_DayAbbreviations },
            { "roc.DayNarrows", metaValue_generic_DayNarrows },
            { "roc.QuarterNames", metaValue_generic_QuarterNames },
            { "roc.QuarterNarrows", metaValue_QuarterNarrows },
            { "roc.narrow.AmPmMarkers", metaValue_generic_narrow_AmPmMarkers },
            { "roc.abbreviated.AmPmMarkers", metaValue_generic_abbreviated_AmPmMarkers },
            { "java.time.roc.long.Eras", metaValue_java_time_roc_long_Eras },
            { "roc.long.Eras", metaValue_java_time_roc_long_Eras },
            { "java.time.roc.Eras", metaValue_java_time_roc_long_Eras },
            { "roc.Eras", metaValue_java_time_roc_long_Eras },
            { "java.time.roc.narrow.Eras", metaValue_java_time_roc_long_Eras },
            { "roc.narrow.Eras", metaValue_java_time_roc_long_Eras },
            { "roc.TimePatterns", metaValue_generic_TimePatterns },
            { "java.time.roc.DatePatterns", metaValue_java_time_generic_DatePatterns },
            { "roc.DatePatterns", metaValue_generic_DatePatterns },
            { "roc.DateFormatItem.yMMMEd", metaValue_generic_DateFormatItem_yMMMEd },
            { "roc.DateFormatItem.yMEd", metaValue_generic_DateFormatItem_yMEd },
            { "roc.DateFormatItem.Gy", metaValue_generic_DateFormatItem_Gy },
            { "roc.DateFormatItem.GyMMMd", metaValue_generic_DateFormatItem_yyyyMMMd },
            { "roc.DateFormatItem.yMMMd", metaValue_generic_DateFormatItem_yMMMd },
            { "roc.DateFormatItem.yw", metaValue_generic_DateFormatItem_yw },
            { "roc.DateFormatItem.yQQQ", metaValue_generic_DateFormatItem_yQQQ },
            { "roc.DateFormatItem.yMMM", metaValue_generic_DateFormatItem_yMMM },
            { "roc.DateFormatItem.Md", metaValue_generic_DateFormatItem_Md },
            { "roc.DateFormatItem.Ed", metaValue_generic_DateFormatItem_Ed },
            { "roc.DateFormatItem.MMMMd", metaValue_generic_DateFormatItem_MMMMd },
            { "roc.DateFormatItem.MEd", metaValue_generic_DateFormatItem_MEd },
            { "roc.DateFormatItem.MMMEd", metaValue_generic_DateFormatItem_MMMEd },
            { "roc.DateFormatItem.GyMd", metaValue_generic_DateFormatItem_yyyyMd },
            { "roc.DateFormatItem.GyMMMEd", metaValue_generic_DateFormatItem_yyyyMMMEd },
            { "roc.DateFormatItem.yMd", metaValue_generic_DateFormatItem_yMd },
            { "roc.DateFormatItem.MMMd", metaValue_generic_DateFormatItem_MMMd },
            { "roc.DateFormatItem.yM", metaValue_generic_DateFormatItem_yM },
            { "roc.DateFormatItem.yMMMM", metaValue_generic_DateFormatItem_yMMMM },
            { "roc.DateFormatItem.MMMMW", metaValue_generic_DateFormatItem_MMMMW },
            { "roc.DateFormatItem.yQQQQ", metaValue_generic_DateFormatItem_yQQQQ },
            { "roc.DateFormatItem.GyMMM", metaValue_generic_DateFormatItem_yyyyMMM },
            { "islamic.MonthNames",
                new String[] {
                    "\ud83a\udd14\ud83a\udd2e\ud83a\udd25\ud83a\udd26\ud83a\udd2b\ud83a\udd32\ud83a\udd3c\ud83a\udd2b",
                    "\ud83a\udd05\ud83a\udd22\ud83a\udd26\ud83a\udd46\ud83a\udd2e\ud83a\udd2a\ud83a\udd23\ud83a\udd35-\ud83a\udd06\ud83a\udd22\ud83a\udd2a\ud83a\udd22\ud83a\udd32",
                    "\ud83a\udd06\ud83a\udd22\ud83a\udd2a\ud83a\udd22\ud83a\udd32",
                    "\ud83a\udd03\ud83a\udd2d\ud83a\udd25\ud83a\udd28\ud83a\udd22\ud83a\udd2a\ud83a\udd22\ud83a\udd32",
                    "\ud83a\udd04\ud83a\udd22\ud83a\udd28\ud83a\udd46\ud83a\udd22\ud83a\udd2a\ud83a\udd22\ud83a\udd32",
                    "\ud83a\udd05\ud83a\udd22\ud83a\udd26\ud83a\udd46\ud83a\udd2e\ud83a\udd2a\ud83a\udd23\ud83a\udd35-\ud83a\udd08\ud83a\udd22\ud83a\udd44\ud83a\udd36\ud83a\udd2d\ud83a\udd26\ud83a\udd2d",
                    "\ud83a\udd08\ud83a\udd22\ud83a\udd44\ud83a\udd36\ud83a\udd2d\ud83a\udd26\ud83a\udd2d",
                    "\ud83a\udd05\ud83a\udd22\ud83a\udd26\ud83a\udd46\ud83a\udd2e\ud83a\udd2a\ud83a\udd23\ud83a\udd35-\ud83a\udd05\ud83a\udd35\ud83a\udd45\ud83a\udd25\ud83a\udd22\ud83a\udd34\ud83a\udd2b\ud83a\udd45",
                    "\ud83a\udd05\ud83a\udd35\ud83a\udd45\ud83a\udd25\ud83a\udd22\ud83a\udd34\ud83a\udd2b\ud83a\udd45",
                    "\ud83a\udd14\ud83a\udd35\ud83a\udd45\ud83a\udd24\ud83a\udd23\ud83a\udd22\ud83a\udd44\ud83a\udd32\ud83a\udd4b\ud83a\udd23\ud83a\udd35",
                    "\ud83a\udd05\ud83a\udd22\ud83a\udd26\ud83a\udd46\ud83a\udd2e\ud83a\udd2a\ud83a\udd23\ud83a\udd35-\ud83a\udd01\ud83a\udd2e\ud83a\udd32\ud83a\udd33\ud83a\udd2d\ud83a\udd32",
                    "\ud83a\udd01\ud83a\udd35\ud83a\udd32\ud83a\udd33\ud83a\udd2d\ud83a\udd32",
                    "",
                }
            },
            { "islamic.MonthAbbreviations",
                new String[] {
                    "\ud83a\udd14\ud83a\udd2e\ud83a\udd26.",
                    "\ud83a\udd05\ud83a\udd22\ud83a\udd28.",
                    "\ud83a\udd06\ud83a\udd22\ud83a\udd2a.",
                    "\ud83a\udd03\ud83a\udd2d\ud83a\udd28.",
                    "\ud83a\udd04\ud83a\udd22\ud83a\udd28.",
                    "\ud83a\udd05\ud83a\udd22\ud83a\udd2a.",
                    "\ud83a\udd08\ud83a\udd22\ud83a\udd36.",
                    "\ud83a\udd05\ud83a\udd22\ud83a\udd27.",
                    "\ud83a\udd05\ud83a\udd35\ud83a\udd25.",
                    "\ud83a\udd14\ud83a\udd35\ud83a\udd24.",
                    "\ud83a\udd05\ud83a\udd22\ud83a\udd23.",
                    "\ud83a\udd01\ud83a\udd2e\ud83a\udd32.",
                    "",
                }
            },
            { "islamic.MonthNarrows",
                new String[] {
                    "\ud83a\udd51",
                    "\ud83a\udd52",
                    "\ud83a\udd53",
                    "\ud83a\udd54",
                    "\ud83a\udd55",
                    "\ud83a\udd56",
                    "\ud83a\udd57",
                    "\ud83a\udd58",
                    "\ud83a\udd59",
                    "\ud83a\udd51\ud83a\udd50",
                    "\ud83a\udd51\ud83a\udd51",
                    "\ud83a\udd51\ud83a\udd52",
                    "",
                }
            },
            { "islamic.DayNames", metaValue_generic_DayNames },
            { "islamic.DayAbbreviations", metaValue_generic_DayAbbreviations },
            { "islamic.QuarterNames", metaValue_generic_QuarterNames },
            { "islamic.narrow.AmPmMarkers", metaValue_generic_narrow_AmPmMarkers },
            { "islamic.abbreviated.AmPmMarkers", metaValue_generic_abbreviated_AmPmMarkers },
            { "java.time.islamic.long.Eras", metaValue_java_time_islamic_long_Eras },
            { "islamic.long.Eras", metaValue_java_time_islamic_long_Eras },
            { "java.time.islamic.Eras", metaValue_java_time_islamic_long_Eras },
            { "islamic.Eras", metaValue_java_time_islamic_long_Eras },
            { "java.time.islamic.narrow.Eras", metaValue_java_time_islamic_long_Eras },
            { "islamic.narrow.Eras", metaValue_java_time_islamic_long_Eras },
            { "islamic.TimePatterns", metaValue_generic_TimePatterns },
            { "java.time.islamic.DatePatterns", metaValue_java_time_generic_DatePatterns },
            { "islamic.DatePatterns", metaValue_generic_DatePatterns },
            { "islamic.DateFormatItem.yMMMEd", metaValue_generic_DateFormatItem_yMMMEd },
            { "islamic.DateFormatItem.yMEd", metaValue_generic_DateFormatItem_yMEd },
            { "islamic.DateFormatItem.Gy", metaValue_generic_DateFormatItem_Gy },
            { "islamic.DateFormatItem.GyMMMd", metaValue_generic_DateFormatItem_yyyyMMMd },
            { "islamic.DateFormatItem.yMMMd", metaValue_generic_DateFormatItem_yMMMd },
            { "islamic.DateFormatItem.yw", metaValue_generic_DateFormatItem_yw },
            { "islamic.DateFormatItem.yQQQ", metaValue_generic_DateFormatItem_yQQQ },
            { "islamic.DateFormatItem.yMMM", metaValue_generic_DateFormatItem_yMMM },
            { "islamic.DateFormatItem.Md", metaValue_generic_DateFormatItem_Md },
            { "islamic.DateFormatItem.Ed", metaValue_generic_DateFormatItem_Ed },
            { "islamic.DateFormatItem.MMMMd", metaValue_generic_DateFormatItem_MMMMd },
            { "islamic.DateFormatItem.MEd", metaValue_generic_DateFormatItem_MEd },
            { "islamic.DateFormatItem.MMMEd", metaValue_generic_DateFormatItem_MMMEd },
            { "islamic.DateFormatItem.GyMd", metaValue_generic_DateFormatItem_yyyyMd },
            { "islamic.DateFormatItem.GyMMMEd", metaValue_generic_DateFormatItem_yyyyMMMEd },
            { "islamic.DateFormatItem.yMd", metaValue_generic_DateFormatItem_yMd },
            { "islamic.DateFormatItem.MMMd", metaValue_generic_DateFormatItem_MMMd },
            { "islamic.DateFormatItem.yM", metaValue_generic_DateFormatItem_yM },
            { "islamic.DateFormatItem.yMMMM", metaValue_generic_DateFormatItem_yMMMM },
            { "islamic.DateFormatItem.MMMMW", metaValue_generic_DateFormatItem_MMMMW },
            { "islamic.DateFormatItem.yQQQQ", metaValue_generic_DateFormatItem_yQQQQ },
            { "islamic.DateFormatItem.GyMMM", metaValue_generic_DateFormatItem_yyyyMMM },
            { "islamic-civil.DateFormatItem.yMMMEd", metaValue_generic_DateFormatItem_yMMMEd },
            { "islamic-civil.DateFormatItem.yMEd", metaValue_generic_DateFormatItem_yMEd },
            { "islamic-civil.DateFormatItem.Gy", metaValue_generic_DateFormatItem_Gy },
            { "islamic-civil.DateFormatItem.GyMMMd", metaValue_generic_DateFormatItem_yyyyMMMd },
            { "islamic-civil.DateFormatItem.yMMMd", metaValue_generic_DateFormatItem_yMMMd },
            { "islamic-civil.DateFormatItem.yw", metaValue_generic_DateFormatItem_yw },
            { "islamic-civil.DateFormatItem.yQQQ", metaValue_generic_DateFormatItem_yQQQ },
            { "islamic-civil.DateFormatItem.yMMM", metaValue_generic_DateFormatItem_yMMM },
            { "islamic-civil.DateFormatItem.Md", metaValue_generic_DateFormatItem_Md },
            { "islamic-civil.DateFormatItem.Ed", metaValue_generic_DateFormatItem_Ed },
            { "islamic-civil.DateFormatItem.MMMMd", metaValue_generic_DateFormatItem_MMMMd },
            { "islamic-civil.DateFormatItem.MEd", metaValue_generic_DateFormatItem_MEd },
            { "islamic-civil.DateFormatItem.MMMEd", metaValue_generic_DateFormatItem_MMMEd },
            { "islamic-civil.DateFormatItem.GyMd", metaValue_generic_DateFormatItem_yyyyMd },
            { "islamic-civil.DateFormatItem.GyMMMEd", metaValue_generic_DateFormatItem_yyyyMMMEd },
            { "islamic-civil.DateFormatItem.yMd", metaValue_generic_DateFormatItem_yMd },
            { "islamic-civil.DateFormatItem.MMMd", metaValue_generic_DateFormatItem_MMMd },
            { "islamic-civil.DateFormatItem.yM", metaValue_generic_DateFormatItem_yM },
            { "islamic-civil.DateFormatItem.yMMMM", metaValue_generic_DateFormatItem_yMMMM },
            { "islamic-civil.DateFormatItem.MMMMW", metaValue_generic_DateFormatItem_MMMMW },
            { "islamic-civil.DateFormatItem.yQQQQ", metaValue_generic_DateFormatItem_yQQQQ },
            { "islamic-civil.DateFormatItem.GyMMM", metaValue_generic_DateFormatItem_yyyyMMM },
            { "islamic-umalqura.DateFormatItem.yMMMEd", metaValue_generic_DateFormatItem_yMMMEd },
            { "islamic-umalqura.DateFormatItem.yMEd", metaValue_generic_DateFormatItem_yMEd },
            { "islamic-umalqura.DateFormatItem.Gy", metaValue_generic_DateFormatItem_Gy },
            { "islamic-umalqura.DateFormatItem.GyMMMd", metaValue_generic_DateFormatItem_yyyyMMMd },
            { "islamic-umalqura.DateFormatItem.yMMMd", metaValue_generic_DateFormatItem_yMMMd },
            { "islamic-umalqura.DateFormatItem.yw", metaValue_generic_DateFormatItem_yw },
            { "islamic-umalqura.DateFormatItem.yQQQ", metaValue_generic_DateFormatItem_yQQQ },
            { "islamic-umalqura.DateFormatItem.yMMM", metaValue_generic_DateFormatItem_yMMM },
            { "islamic-umalqura.DateFormatItem.Md", metaValue_generic_DateFormatItem_Md },
            { "islamic-umalqura.DateFormatItem.Ed", metaValue_generic_DateFormatItem_Ed },
            { "islamic-umalqura.DateFormatItem.MMMMd", metaValue_generic_DateFormatItem_MMMMd },
            { "islamic-umalqura.DateFormatItem.MEd", metaValue_generic_DateFormatItem_MEd },
            { "islamic-umalqura.DateFormatItem.MMMEd", metaValue_generic_DateFormatItem_MMMEd },
            { "islamic-umalqura.DateFormatItem.GyMd", metaValue_generic_DateFormatItem_yyyyMd },
            { "islamic-umalqura.DateFormatItem.GyMMMEd", metaValue_generic_DateFormatItem_yyyyMMMEd },
            { "islamic-umalqura.DateFormatItem.yMd", metaValue_generic_DateFormatItem_yMd },
            { "islamic-umalqura.DateFormatItem.MMMd", metaValue_generic_DateFormatItem_MMMd },
            { "islamic-umalqura.DateFormatItem.yM", metaValue_generic_DateFormatItem_yM },
            { "islamic-umalqura.DateFormatItem.yMMMM", metaValue_generic_DateFormatItem_yMMMM },
            { "islamic-umalqura.DateFormatItem.MMMMW", metaValue_generic_DateFormatItem_MMMMW },
            { "islamic-umalqura.DateFormatItem.yQQQQ", metaValue_generic_DateFormatItem_yQQQQ },
            { "islamic-umalqura.DateFormatItem.GyMMM", metaValue_generic_DateFormatItem_yyyyMMM },
            { "calendarname.buddhist", "\ud83a\udd19\ud83a\udd22\ud83a\udd24\ud83a\udd2f\ud83a\udd2d\ud83a\udd25\ud83a\udd2b\ud83a\udd2a\ud83a\udd2b \ud83a\udd04\ud83a\udd35\ud83a\udd45\ud83a\udd23\ud83a\udd22\ud83a\udd34\ud83a\udd22\ud83a\udd32\ud83a\udd33\ud83a\udd2e" },
            { "calendarname.japanese", "\ud83a\udd19\ud83a\udd22\ud83a\udd24\ud83a\udd2f\ud83a\udd2d\ud83a\udd25\ud83a\udd2b\ud83a\udd2a\ud83a\udd2b \ud83a\udd14\ud83a\udd22\ud83a\udd44\ud83a\udd28\ud83a\udd2e\ud83a\udd32\ud83a\udd2d\ud83a\udd32\ud83a\udd33\ud83a\udd2e" },
            { "calendarname.roc", "\ud83a\udd19\ud83a\udd22\ud83a\udd24\ud83a\udd2f\ud83a\udd2d\ud83a\udd25\ud83a\udd2b\ud83a\udd2a\ud83a\udd2b \ud83a\udd18\ud83a\udd2b\ud83a\udd32\ud83a\udd23\ud83a\udd2d\ud83a\udd34\ud83a\udd22\ud83a\udd32\ud83a\udd33\ud83a\udd2e \ud83a\udd05\ud83a\udd2d\ud83a\udd45\ud83a\udd32" },
            { "calendarname.gregorian", metaValue_calendarname_gregorian },
            { "calendarname.gregory", metaValue_calendarname_gregorian },
            { "DefaultNumberingSystem", "adlm" },
            { "adlm.NumberElements",
                new String[] {
                    ".",
                    ",",
                    ";",
                    "%",
                    "0",
                    "#",
                    "-",
                    "\ud83a\udd09",
                    "\u2030",
                    "\u221e",
                    "NaN",
                    "",
                    "",
                }
            },
            { "adlm.NumberPatterns", metaValue_adlm_NumberPatterns },
            { "latn.NumberElements",
                new String[] {
                    ".",
                    "\u2e41",
                    "\u204f",
                    "%",
                    "0",
                    "#",
                    "-",
                    "E",
                    "\u2030",
                    "\u221e",
                    "NaN",
                    "",
                    "",
                }
            },
            { "latn.NumberPatterns", metaValue_adlm_NumberPatterns },
            { "arabext.NumberElements",
                new String[] {
                    "\u066b",
                    "\u066c",
                    "\u061b",
                    "\u066a",
                    "\u06f0",
                    "#",
                    "\u200e-\u200e",
                    "\u00d7\u06f1\u06f0^",
                    "\u0609",
                    "\u221e",
                    "NaN",
                    "",
                    "",
                }
            },
            { "arabext.NumberPatterns", metaValue_adlm_NumberPatterns },
            { "bali.NumberElements",
                new String[] {
                    ".",
                    ",",
                    ";",
                    "%",
                    "\u1b50",
                    "#",
                    "-",
                    "E",
                    "\u2030",
                    "\u221e",
                    "NaN",
                    "",
                    "",
                }
            },
            { "bali.NumberPatterns", metaValue_adlm_NumberPatterns },
            { "beng.NumberElements",
                new String[] {
                    ".",
                    ",",
                    ";",
                    "%",
                    "\u09e6",
                    "#",
                    "-",
                    "E",
                    "\u2030",
                    "\u221e",
                    "NaN",
                    "",
                    "",
                }
            },
            { "beng.NumberPatterns", metaValue_adlm_NumberPatterns },
            { "brah.NumberElements", metaValue_brah_NumberElements },
            { "brah.NumberPatterns", metaValue_adlm_NumberPatterns },
            { "cakm.NumberElements", metaValue_brah_NumberElements },
            { "cakm.NumberPatterns", metaValue_adlm_NumberPatterns },
            { "cham.NumberElements",
                new String[] {
                    ".",
                    ",",
                    ";",
                    "%",
                    "\uaa50",
                    "#",
                    "-",
                    "E",
                    "\u2030",
                    "\u221e",
                    "NaN",
                    "",
                    "",
                }
            },
            { "cham.NumberPatterns", metaValue_adlm_NumberPatterns },
            { "deva.NumberElements",
                new String[] {
                    ".",
                    ",",
                    ";",
                    "%",
                    "\u0966",
                    "#",
                    "-",
                    "E",
                    "\u2030",
                    "\u221e",
                    "NaN",
                    "",
                    "",
                }
            },
            { "deva.NumberPatterns", metaValue_adlm_NumberPatterns },
            { "fullwide.NumberElements",
                new String[] {
                    ".",
                    ",",
                    ";",
                    "%",
                    "\uff10",
                    "#",
                    "-",
                    "E",
                    "\u2030",
                    "\u221e",
                    "NaN",
                    "",
                    "",
                }
            },
            { "fullwide.NumberPatterns", metaValue_adlm_NumberPatterns },
            { "gong.NumberElements", metaValue_brah_NumberElements },
            { "gong.NumberPatterns", metaValue_adlm_NumberPatterns },
            { "gonm.NumberElements", metaValue_brah_NumberElements },
            { "gonm.NumberPatterns", metaValue_adlm_NumberPatterns },
            { "gujr.NumberElements",
                new String[] {
                    ".",
                    ",",
                    ";",
                    "%",
                    "\u0ae6",
                    "#",
                    "-",
                    "E",
                    "\u2030",
                    "\u221e",
                    "NaN",
                    "",
                    "",
                }
            },
            { "gujr.NumberPatterns", metaValue_adlm_NumberPatterns },
            { "guru.NumberElements",
                new String[] {
                    ".",
                    ",",
                    ";",
                    "%",
                    "\u0a66",
                    "#",
                    "-",
                    "E",
                    "\u2030",
                    "\u221e",
                    "NaN",
                    "",
                    "",
                }
            },
            { "guru.NumberPatterns", metaValue_adlm_NumberPatterns },
            { "hanidec.NumberElements", metaValue_brah_NumberElements },
            { "hanidec.NumberPatterns", metaValue_adlm_NumberPatterns },
            { "java.NumberElements",
                new String[] {
                    ".",
                    ",",
                    ";",
                    "%",
                    "\ua9d0",
                    "#",
                    "-",
                    "E",
                    "\u2030",
                    "\u221e",
                    "NaN",
                    "",
                    "",
                }
            },
            { "java.NumberPatterns", metaValue_adlm_NumberPatterns },
            { "kali.NumberElements",
                new String[] {
                    ".",
                    ",",
                    ";",
                    "%",
                    "\ua900",
                    "#",
                    "-",
                    "E",
                    "\u2030",
                    "\u221e",
                    "NaN",
                    "",
                    "",
                }
            },
            { "kali.NumberPatterns", metaValue_adlm_NumberPatterns },
            { "khmr.NumberElements",
                new String[] {
                    ".",
                    ",",
                    ";",
                    "%",
                    "\u17e0",
                    "#",
                    "-",
                    "E",
                    "\u2030",
                    "\u221e",
                    "NaN",
                    "",
                    "",
                }
            },
            { "khmr.NumberPatterns", metaValue_adlm_NumberPatterns },
            { "knda.NumberElements",
                new String[] {
                    ".",
                    ",",
                    ";",
                    "%",
                    "\u0ce6",
                    "#",
                    "-",
                    "E",
                    "\u2030",
                    "\u221e",
                    "NaN",
                    "",
                    "",
                }
            },
            { "knda.NumberPatterns", metaValue_adlm_NumberPatterns },
            { "lana.NumberElements",
                new String[] {
                    ".",
                    ",",
                    ";",
                    "%",
                    "\u1a80",
                    "#",
                    "-",
                    "E",
                    "\u2030",
                    "\u221e",
                    "NaN",
                    "",
                    "",
                }
            },
            { "lana.NumberPatterns", metaValue_adlm_NumberPatterns },
            { "lanatham.NumberElements",
                new String[] {
                    ".",
                    ",",
                    ";",
                    "%",
                    "\u1a90",
                    "#",
                    "-",
                    "E",
                    "\u2030",
                    "\u221e",
                    "NaN",
                    "",
                    "",
                }
            },
            { "lanatham.NumberPatterns", metaValue_adlm_NumberPatterns },
            { "laoo.NumberElements",
                new String[] {
                    ".",
                    ",",
                    ";",
                    "%",
                    "\u0ed0",
                    "#",
                    "-",
                    "E",
                    "\u2030",
                    "\u221e",
                    "NaN",
                    "",
                    "",
                }
            },
            { "laoo.NumberPatterns", metaValue_adlm_NumberPatterns },
            { "lepc.NumberElements",
                new String[] {
                    ".",
                    ",",
                    ";",
                    "%",
                    "\u1c40",
                    "#",
                    "-",
                    "E",
                    "\u2030",
                    "\u221e",
                    "NaN",
                    "",
                    "",
                }
            },
            { "lepc.NumberPatterns", metaValue_adlm_NumberPatterns },
            { "limb.NumberElements",
                new String[] {
                    ".",
                    ",",
                    ";",
                    "%",
                    "\u1946",
                    "#",
                    "-",
                    "E",
                    "\u2030",
                    "\u221e",
                    "NaN",
                    "",
                    "",
                }
            },
            { "limb.NumberPatterns", metaValue_adlm_NumberPatterns },
            { "mlym.NumberElements",
                new String[] {
                    ".",
                    ",",
                    ";",
                    "%",
                    "\u0d66",
                    "#",
                    "-",
                    "E",
                    "\u2030",
                    "\u221e",
                    "NaN",
                    "",
                    "",
                }
            },
            { "mlym.NumberPatterns", metaValue_adlm_NumberPatterns },
            { "mong.NumberElements",
                new String[] {
                    ".",
                    ",",
                    ";",
                    "%",
                    "\u1810",
                    "#",
                    "-",
                    "E",
                    "\u2030",
                    "\u221e",
                    "NaN",
                    "",
                    "",
                }
            },
            { "mong.NumberPatterns", metaValue_adlm_NumberPatterns },
            { "mtei.NumberElements",
                new String[] {
                    ".",
                    ",",
                    ";",
                    "%",
                    "\uabf0",
                    "#",
                    "-",
                    "E",
                    "\u2030",
                    "\u221e",
                    "NaN",
                    "",
                    "",
                }
            },
            { "mtei.NumberPatterns", metaValue_adlm_NumberPatterns },
            { "mymr.NumberElements",
                new String[] {
                    ".",
                    ",",
                    ";",
                    "%",
                    "\u1040",
                    "#",
                    "-",
                    "E",
                    "\u2030",
                    "\u221e",
                    "NaN",
                    "",
                    "",
                }
            },
            { "mymr.NumberPatterns", metaValue_adlm_NumberPatterns },
            { "mymrshan.NumberElements",
                new String[] {
                    ".",
                    ",",
                    ";",
                    "%",
                    "\u1090",
                    "#",
                    "-",
                    "E",
                    "\u2030",
                    "\u221e",
                    "NaN",
                    "",
                    "",
                }
            },
            { "mymrshan.NumberPatterns", metaValue_adlm_NumberPatterns },
            { "nkoo.NumberElements",
                new String[] {
                    ".",
                    ",",
                    ";",
                    "%",
                    "\u07c0",
                    "#",
                    "-",
                    "E",
                    "\u2030",
                    "\u221e",
                    "NaN",
                    "",
                    "",
                }
            },
            { "nkoo.NumberPatterns", metaValue_adlm_NumberPatterns },
            { "olck.NumberElements",
                new String[] {
                    ".",
                    ",",
                    ";",
                    "%",
                    "\u1c50",
                    "#",
                    "-",
                    "E",
                    "\u2030",
                    "\u221e",
                    "NaN",
                    "",
                    "",
                }
            },
            { "olck.NumberPatterns", metaValue_adlm_NumberPatterns },
            { "orya.NumberElements",
                new String[] {
                    ".",
                    ",",
                    ";",
                    "%",
                    "\u0b66",
                    "#",
                    "-",
                    "E",
                    "\u2030",
                    "\u221e",
                    "NaN",
                    "",
                    "",
                }
            },
            { "orya.NumberPatterns", metaValue_adlm_NumberPatterns },
            { "osma.NumberElements", metaValue_brah_NumberElements },
            { "osma.NumberPatterns", metaValue_adlm_NumberPatterns },
            { "rohg.NumberElements", metaValue_brah_NumberElements },
            { "rohg.NumberPatterns", metaValue_adlm_NumberPatterns },
            { "saur.NumberElements",
                new String[] {
                    ".",
                    ",",
                    ";",
                    "%",
                    "\ua8d0",
                    "#",
                    "-",
                    "E",
                    "\u2030",
                    "\u221e",
                    "NaN",
                    "",
                    "",
                }
            },
            { "saur.NumberPatterns", metaValue_adlm_NumberPatterns },
            { "shrd.NumberElements", metaValue_brah_NumberElements },
            { "shrd.NumberPatterns", metaValue_adlm_NumberPatterns },
            { "sora.NumberElements", metaValue_brah_NumberElements },
            { "sora.NumberPatterns", metaValue_adlm_NumberPatterns },
            { "sund.NumberElements",
                new String[] {
                    ".",
                    ",",
                    ";",
                    "%",
                    "\u1bb0",
                    "#",
                    "-",
                    "E",
                    "\u2030",
                    "\u221e",
                    "NaN",
                    "",
                    "",
                }
            },
            { "sund.NumberPatterns", metaValue_adlm_NumberPatterns },
            { "takr.NumberElements", metaValue_brah_NumberElements },
            { "takr.NumberPatterns", metaValue_adlm_NumberPatterns },
            { "talu.NumberElements",
                new String[] {
                    ".",
                    ",",
                    ";",
                    "%",
                    "\u19d0",
                    "#",
                    "-",
                    "E",
                    "\u2030",
                    "\u221e",
                    "NaN",
                    "",
                    "",
                }
            },
            { "talu.NumberPatterns", metaValue_adlm_NumberPatterns },
            { "tamldec.NumberElements",
                new String[] {
                    ".",
                    ",",
                    ";",
                    "%",
                    "\u0be6",
                    "#",
                    "-",
                    "E",
                    "\u2030",
                    "\u221e",
                    "NaN",
                    "",
                    "",
                }
            },
            { "tamldec.NumberPatterns", metaValue_adlm_NumberPatterns },
            { "telu.NumberElements",
                new String[] {
                    ".",
                    ",",
                    ";",
                    "%",
                    "\u0c66",
                    "#",
                    "-",
                    "E",
                    "\u2030",
                    "\u221e",
                    "NaN",
                    "",
                    "",
                }
            },
            { "telu.NumberPatterns", metaValue_adlm_NumberPatterns },
            { "thai.NumberElements",
                new String[] {
                    ".",
                    ",",
                    ";",
                    "%",
                    "\u0e50",
                    "#",
                    "-",
                    "E",
                    "\u2030",
                    "\u221e",
                    "NaN",
                    "",
                    "",
                }
            },
            { "thai.NumberPatterns", metaValue_adlm_NumberPatterns },
            { "tibt.NumberElements",
                new String[] {
                    ".",
                    ",",
                    ";",
                    "%",
                    "\u0f20",
                    "#",
                    "-",
                    "E",
                    "\u2030",
                    "\u221e",
                    "NaN",
                    "",
                    "",
                }
            },
            { "tibt.NumberPatterns", metaValue_adlm_NumberPatterns },
            { "vaii.NumberElements",
                new String[] {
                    ".",
                    ",",
                    ";",
                    "%",
                    "\ua620",
                    "#",
                    "-",
                    "E",
                    "\u2030",
                    "\u221e",
                    "NaN",
                    "",
                    "",
                }
            },
            { "vaii.NumberPatterns", metaValue_adlm_NumberPatterns },
            { "short.CompactNumberPatterns",
                new String[] {
                    "",
                    "",
                    "",
                    "{one:0\ud83a\udd13 other:0\ud83a\udd13}",
                    "{one:00\ud83a\udd13 other:00\ud83a\udd13}",
                    "{one:000\ud83a\udd13 other:000\ud83a\udd13}",
                    "{one:0\ud83a\udd01 other:0\ud83a\udd01}",
                    "{one:00\ud83a\udd01 other:00\ud83a\udd01}",
                    "{one:000\ud83a\udd01 other:000\ud83a\udd01}",
                    "{one:0\ud83a\udd01 one:\ud83a\udd36 other:0\ud83a\udd01 other:\ud83a\udd36}",
                    "{one:00\ud83a\udd01 one:\ud83a\udd36 other:00\ud83a\udd01 other:\ud83a\udd36}",
                    "{one:000\ud83a\udd01 one:\ud83a\udd36 other:000\ud83a\udd01 other:\ud83a\udd36}",
                    "{one:0\ud83a\udd1a other:0\ud83a\udd1a}",
                    "{one:00\ud83a\udd1a other:00\ud83a\udd1a}",
                    "{one:000\ud83a\udd1a other:000\ud83a\udd1a}",
                }
            },
            { "long.CompactNumberPatterns",
                new String[] {
                    "",
                    "",
                    "",
                    "{one:0' '\ud83a\udd35 one:\ud83a\udd36 one:\ud83a\udd35 one:\ud83a\udd32 one:\ud83a\udd2b one:\ud83a\udd2a one:\ud83a\udd2b other:0' '\ud83a\udd35 other:\ud83a\udd36 other:\ud83a\udd35 other:\ud83a\udd32 other:\ud83a\udd2b other:\ud83a\udd2a other:\ud83a\udd2b}",
                    "{one:00' '\ud83a\udd35 one:\ud83a\udd36 one:\ud83a\udd35 one:\ud83a\udd32 one:\ud83a\udd2b one:\ud83a\udd2a one:\ud83a\udd2b other:00' '\ud83a\udd35 other:\ud83a\udd36 other:\ud83a\udd35 other:\ud83a\udd32 other:\ud83a\udd2b other:\ud83a\udd2a other:\ud83a\udd2b}",
                    "{one:000' '\ud83a\udd35 one:\ud83a\udd36 one:\ud83a\udd35 one:\ud83a\udd32 one:\ud83a\udd2b one:\ud83a\udd2a one:\ud83a\udd2b other:000' '\ud83a\udd35 other:\ud83a\udd36 other:\ud83a\udd35 other:\ud83a\udd32 other:\ud83a\udd2b other:\ud83a\udd2a other:\ud83a\udd2b}",
                    "{one:0' '\ud83a\udd23 one:\ud83a\udd35 one:\ud83a\udd26 one:\ud83a\udd35 one:\ud83a\udd32 one:\ud83a\udd2b one:\ud83a\udd2a one:\ud83a\udd2b other:0' '\ud83a\udd23 other:\ud83a\udd35 other:\ud83a\udd26 other:\ud83a\udd35 other:\ud83a\udd32 other:\ud83a\udd2b other:\ud83a\udd2a other:\ud83a\udd2b}",
                    "{one:00' '\ud83a\udd23 one:\ud83a\udd35 one:\ud83a\udd26 one:\ud83a\udd35 one:\ud83a\udd32 one:\ud83a\udd2b one:\ud83a\udd2a one:\ud83a\udd2b other:00' '\ud83a\udd23 other:\ud83a\udd35 other:\ud83a\udd26 other:\ud83a\udd35 other:\ud83a\udd32 other:\ud83a\udd2b other:\ud83a\udd2a other:\ud83a\udd2b}",
                    "{one:000' '\ud83a\udd23 one:\ud83a\udd35 one:\ud83a\udd26 one:\ud83a\udd35 one:\ud83a\udd32 one:\ud83a\udd2b one:\ud83a\udd2a one:\ud83a\udd2b other:000' '\ud83a\udd23 other:\ud83a\udd35 other:\ud83a\udd26 other:\ud83a\udd35 other:\ud83a\udd32 other:\ud83a\udd2b other:\ud83a\udd2a other:\ud83a\udd2b}",
                    "{one:0' '\ud83a\udd23 one:\ud83a\udd35 one:\ud83a\udd36 one:\ud83a\udd35 one:\ud83a\udd32 one:\ud83a\udd2b one:\ud83a\udd2a one:\ud83a\udd2b other:0' '\ud83a\udd23 other:\ud83a\udd35 other:\ud83a\udd36 other:\ud83a\udd35 other:\ud83a\udd32 other:\ud83a\udd2b other:\ud83a\udd2a other:\ud83a\udd2b}",
                    "{one:00' '\ud83a\udd23 one:\ud83a\udd35 one:\ud83a\udd36 one:\ud83a\udd35 one:\ud83a\udd32 one:\ud83a\udd2b one:\ud83a\udd2a one:\ud83a\udd2b other:00' '\ud83a\udd23 other:\ud83a\udd35 other:\ud83a\udd36 other:\ud83a\udd35 other:\ud83a\udd32 other:\ud83a\udd2b other:\ud83a\udd2a other:\ud83a\udd2b}",
                    "{one:000' '\ud83a\udd23 one:\ud83a\udd35 one:\ud83a\udd36 one:\ud83a\udd35 one:\ud83a\udd32 one:\ud83a\udd2b one:\ud83a\udd2a one:\ud83a\udd2b other:000' '\ud83a\udd23 other:\ud83a\udd35 other:\ud83a\udd36 other:\ud83a\udd35 other:\ud83a\udd32 other:\ud83a\udd2b other:\ud83a\udd2a other:\ud83a\udd2b}",
                    "{one:0' '\ud83a\udd3c one:\ud83a\udd35 one:\ud83a\udd36 one:\ud83a\udd35 one:\ud83a\udd32 one:\ud83a\udd2b one:\ud83a\udd2a one:\ud83a\udd2b other:0' '\ud83a\udd3c other:\ud83a\udd35 other:\ud83a\udd36 other:\ud83a\udd35 other:\ud83a\udd32 other:\ud83a\udd2b other:\ud83a\udd2a other:\ud83a\udd2b}",
                    "{one:00' '\ud83a\udd3c one:\ud83a\udd35 one:\ud83a\udd36 one:\ud83a\udd35 one:\ud83a\udd32 one:\ud83a\udd2b one:\ud83a\udd2a one:\ud83a\udd2b other:00' '\ud83a\udd3c other:\ud83a\udd35 other:\ud83a\udd36 other:\ud83a\udd35 other:\ud83a\udd32 other:\ud83a\udd2b other:\ud83a\udd2a other:\ud83a\udd2b}",
                    "{one:000' '\ud83a\udd3c one:\ud83a\udd35 one:\ud83a\udd36 one:\ud83a\udd35 one:\ud83a\udd32 one:\ud83a\udd2b one:\ud83a\udd2a one:\ud83a\udd2b other:000' '\ud83a\udd3c other:\ud83a\udd35 other:\ud83a\udd36 other:\ud83a\udd35 other:\ud83a\udd32 other:\ud83a\udd2b other:\ud83a\udd2a other:\ud83a\udd2b}",
                }
            },
            { "ListPatterns_standard",
                new String[] {
                    "{0}\u2e41 {1}",
                    "{0}\u2e41 {1}",
                    "{0}\u2e41 \ud83a\udd2b {1}",
                    "{0} \ud83a\udd2b {1}",
                    "",
                }
            },
            { "ListPatterns_standard-short",
                new String[] {
                    "{0}\u2e41 {1}",
                    "{0}\u2e41 {1}",
                    "{0}\u2e41 & {1}",
                    "{0} & {1}",
                    "",
                }
            },
            { "ListPatterns_standard-narrow",
                new String[] {
                    "{0}\u2e41 {1}",
                    "{0}\u2e41 {1}",
                    "{0}\u2e41 {1}",
                    "{0}\u2e41 {1}",
                    "",
                }
            },
            { "ListPatterns_or", metaValue_ListPatterns_or },
            { "ListPatterns_or-short", metaValue_ListPatterns_or },
            { "ListPatterns_or-narrow", metaValue_ListPatterns_or },
            { "ListPatterns_unit",
                new String[] {
                    "{0}\u2e41 {1}",
                    "{0}\u2e41 {1}",
                    "{0} \ud83a\udd2b {1}",
                    "{0} \ud83a\udd2b {1}",
                    "",
                }
            },
            { "ListPatterns_unit-short",
                new String[] {
                    "{0}\u2e41 {1}",
                    "{0}, {1}",
                    "{0}, {1}",
                    "{0} \ud83a\udd2b {1}",
                    "",
                }
            },
            { "ListPatterns_unit-narrow",
                new String[] {
                    "{0} {1}",
                    "{0} {1}",
                    "{0} {1}",
                    "{0} {1}",
                    "",
                }
            },
        };
        return data;
    }
}
