package org.openqa.selenium.devtools.v140.network.model;

import org.openqa.selenium.Beta;
import org.openqa.selenium.json.JsonInput;

/**
 * Fired when WebTransport handshake is finished.
 */
public class WebTransportConnectionEstablished {

    private final org.openqa.selenium.devtools.v140.network.model.RequestId transportId;

    private final org.openqa.selenium.devtools.v140.network.model.MonotonicTime timestamp;

    public WebTransportConnectionEstablished(org.openqa.selenium.devtools.v140.network.model.RequestId transportId, org.openqa.selenium.devtools.v140.network.model.MonotonicTime timestamp) {
        this.transportId = java.util.Objects.requireNonNull(transportId, "transportId is required");
        this.timestamp = java.util.Objects.requireNonNull(timestamp, "timestamp is required");
    }

    /**
     * WebTransport identifier.
     */
    public org.openqa.selenium.devtools.v140.network.model.RequestId getTransportId() {
        return transportId;
    }

    /**
     * Timestamp.
     */
    public org.openqa.selenium.devtools.v140.network.model.MonotonicTime getTimestamp() {
        return timestamp;
    }

    private static WebTransportConnectionEstablished fromJson(JsonInput input) {
        org.openqa.selenium.devtools.v140.network.model.RequestId transportId = null;
        org.openqa.selenium.devtools.v140.network.model.MonotonicTime timestamp = null;
        input.beginObject();
        while (input.hasNext()) {
            switch(input.nextName()) {
                case "transportId":
                    transportId = input.read(org.openqa.selenium.devtools.v140.network.model.RequestId.class);
                    break;
                case "timestamp":
                    timestamp = input.read(org.openqa.selenium.devtools.v140.network.model.MonotonicTime.class);
                    break;
                default:
                    input.skipValue();
                    break;
            }
        }
        input.endObject();
        return new WebTransportConnectionEstablished(transportId, timestamp);
    }
}
